/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;

public class Gaussian
extends UnivariateRealFunction {
    public final double a;
    public final double c;
    public final double b;

    public Gaussian() {
        this(1.0 / Constant.ROOT_2_PI, 0.0, 1.0);
    }

    public Gaussian(double a2, double b2, double c2) {
        this.a = a2;
        this.b = b2;
        this.c = c2;
    }

    @Override
    public double evaluate(double x) {
        double a2 = (x - this.b) / this.c;
        a2 *= a2;
        a2 /= -2.0;
        a2 = this.a * Math.exp(a2);
        return a2;
    }
}

