/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.BivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.ContinuedFraction;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.analysis.sequence.Summation;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class GammaRegularizedQ
extends BivariateRealFunction {
    private static final LogGamma E = new LogGamma();

    private double k(final double a2, final double a3) {
        GammaRegularizedQ a4;
        double a5 = new Summation(new Summation.Term(){
            public double term;
            {
                1 a22;
            }

            @Override
            public double evaluate(double n) {
                this.term = n == 0.0 ? 1.0 / a2 : (this.term *= a3 / (a2 + n));
                return this.term;
            }
        }, Constant.EPSILON).sumToInfinity(0);
        double a6 = a2 * Math.log(a3) - a3 - E.evaluate(a2);
        a6 = Math.exp(a6);
        return 1.0 - a6 * a5;
    }

    @Override
    public double evaluate(double s2, double x) {
        SuanShuUtils.assertArgument(s2 >= 0.0, "s must be >= 0", new Object[0]);
        SuanShuUtils.assertArgument(x >= 0.0, "x < 0 gives complex number; not supported yet", new Object[0]);
        if (DoubleUtils.compare(s2, 0.0) == 0) {
            return 0.0;
        }
        if (DoubleUtils.compare(x, 0.0) == 0) {
            return 1.0;
        }
        if (x > 1.0E8) {
            return 0.0;
        }
        if (x < s2 + 1.0) {
            return this.k(s2, x);
        }
        return this.b(s2, x);
    }

    private double m(double a2, double a3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private double b(final double a2, final double a3) {
        GammaRegularizedQ a4;
        ContinuedFraction.Partials a5 = new ContinuedFraction.Partials(){

            @Override
            public double A(int n) {
                if (n == 1) {
                    return 1.0;
                }
                return (double)(n - 1) * (a2 - (double)(n - 1));
            }
            {
                2 a22;
            }

            @Override
            public double B(int n) {
                if (n == 0) {
                    return 0.0;
                }
                return (double)(2 * n - 1) - a2 + a3;
            }
        };
        double a6 = a2 * Math.log(a3) - a3 - E.evaluate(a2);
        a6 = Math.exp(a6);
        return a6 *= new ContinuedFraction().evaluate(a5);
    }
}

