/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.sequence.Summation;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Digamma
extends UnivariateRealFunction {
    private static final double[] L;
    private static final double E = 10.0;

    @Override
    public double evaluate(final double x) {
        double a2 = 0.0;
        if (Double.isNaN(x)) {
            throw new RuntimeException("x = NaN");
        }
        if (DoubleUtils.compare(x, 0.0) == 0) {
            a2 = Double.NEGATIVE_INFINITY;
        } else if (x < 0.0) {
            a2 = this.evaluate(-x) - 1.0 / x + Math.PI / Math.tan(Math.PI * -x);
        } else if (x >= 10.0) {
            int a3;
            a2 = Math.log(x);
            a2 += L[0] / x;
            int n = a3 = 1;
            while (n < L.length) {
                a2 += L[a3] / Math.pow(x, 2 * a3);
                n = ++a3;
            }
        } else {
            int a4 = (int)Math.ceil(10.0 - x);
            a2 = this.evaluate(x + (double)a4);
            a2 -= new Summation(new Summation.Term(){
                {
                    1 a2;
                }

                @Override
                public double evaluate(double k) {
                    return 1.0 / (x + k);
                }
            }).sum(0, a4 - 1);
        }
        return a2;
    }

    static {
        double[] dArray = new double[21];
        dArray[0] = -0.5;
        dArray[1] = -0.0833333333333333;
        dArray[2] = 0.008333333333333333;
        dArray[3] = -0.003968253968253968;
        dArray[4] = 0.004166666666666667;
        dArray[5] = -0.007575757575757576;
        dArray[6] = 0.02109279609279609;
        dArray[7] = -0.08333333333333334;
        dArray[8] = 0.4432598039215686;
        dArray[9] = -3.05395433027012;
        dArray[10] = 26.45621212121212;
        dArray[11] = -281.4601449275362;
        dArray[12] = 3607.510546398047;
        dArray[13] = -54827.5833333333;
        dArray[14] = 974936.823850575;
        dArray[15] = -2.005269579668808E7;
        dArray[16] = 4.7238486772163E8;
        dArray[17] = -1.263572479591667E10;
        dArray[18] = 3.808793112524537E11;
        dArray[19] = -1.285085049930508E13;
        dArray[20] = 4.824144835485017E14;
        L = dArray;
    }
}

