/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;

public class CumulativeNormal
extends UnivariateRealFunction {
    private static final double[] H;
    private static final double f = -1.821255978;
    private Method M;
    private static final double i = 0.2316419;
    private static final double G = 1.330274429;
    private static final double F = 0.31938153;
    private static final double k = 1.781477937;
    private static final double L;
    private static final double E = -0.356563782;

    @Override
    public double evaluate(double x) {
        switch (this.M) {
            case HASTINGS: {
                return this.m(x);
            }
            case MARSAGLIA: {
                do {
                } while (false);
                return this.b(x);
            }
        }
        throw new RuntimeException("unrecognized method");
    }

    public CumulativeNormal() {
        this.M = Method.MARSAGLIA;
    }

    static {
        double[] dArray = new double[15];
        dArray[0] = 1.2533141373155;
        dArray[1] = 0.6556795424187986;
        dArray[2] = 0.4213692292880545;
        dArray[3] = 0.3045902987101033;
        dArray[4] = 0.2366523829135607;
        dArray[5] = 0.1928081047153158;
        dArray[6] = 0.1623776608968675;
        dArray[7] = 0.1401041834530502;
        dArray[8] = 0.1231319632579329;
        dArray[9] = 0.1097872825783083;
        dArray[10] = 0.09902859647173193;
        dArray[11] = 0.09017567550106469;
        dArray[12] = 0.08276628650136918;
        dArray[13] = 0.0764757610162485;
        dArray[14] = 0.07106958053885211;
        H = dArray;
        L = Math.log(Constant.ROOT_2_PI);
    }

    public CumulativeNormal(Method method) {
        this.M = method;
    }

    private double m(double a2) {
        double a3 = Math.abs(a2);
        double a4 = 1.0 / (1.0 + a3 * 0.2316419);
        double a5 = ((((1.330274429 * a4 + -1.821255978) * a4 + 1.781477937) * a4 + -0.356563782) * a4 + 0.31938153) * a4 * Math.exp(-0.5 * a2 * a2 - L);
        a5 = a2 < 0.0 ? a5 : 1.0 - a5;
        return a5;
    }

    private double b(double a2) {
        int a3;
        if (a2 < -15.0) {
            return 0.0;
        }
        if (a2 > 15.0) {
            return 1.0;
        }
        double a4 = Math.abs(a2);
        int a5 = (int)Math.min(Math.abs(a2) + 0.5, 14.0);
        double a6 = a5;
        double a7 = a4 - a6;
        double a8 = H[a5];
        double a9 = a6 * a8 - 1.0;
        double a10 = 1.0;
        double a11 = a8 + a7 * a9;
        int n = a3 = 2;
        while (true) {
            if (n > 24 - a5) break;
            a8 = (a8 + a6 * a9) / (double)a3;
            a9 = (a9 + a6 * a8) / ((double)a3 + 1.0);
            a10 = a10 * a7 * a7;
            a11 += a10 * (a8 + a7 * a9);
            n = a3 += 2;
        }
        double a22 = a11 * Math.exp(-0.5 * a2 * a2 - L);
        a22 = a2 < 0.0 ? a22 : 1.0 - a22;
        return a22;
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method HASTINGS = new Method();
        public static final /* enum */ Method MARSAGLIA = new Method();
        private static final /* synthetic */ Method[] E;
        public static final /* enum */ Method GAMMA = new Method();

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        public static Method[] values() {
            return (Method[])E.clone();
        }

        private Method() {
            Method a2;
        }

        static {
            Method[] methodArray = new Method[3];
            methodArray[0] = HASTINGS;
            methodArray[1] = MARSAGLIA;
            methodArray[2] = GAMMA;
            E = methodArray;
        }
    }
}

