/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.QuadraticSyntheticDivision;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.Quadratic;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JtStep;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JtUtils;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.number.NumberUtils;
import com.numericalmethod.suanshu.number.complex.Complex;

public class JtVariableShiftQuadratic
extends JtStep {
    public final Quadratic quadratic;
    public final Polynomial pPoly;
    public final int maxIterations;
    public final Polynomial kPoly;
    public final double initialV;
    public final double initialU;

    public JtVariableShiftQuadratic(Polynomial a2, Polynomial a3, double a4, double a5, Quadratic a6, int a7) {
        JtVariableShiftQuadratic a8;
        a8.pPoly = a2;
        a8.kPoly = a3;
        a8.initialU = a4;
        a8.initialV = a5;
        a8.quadratic = a6;
        a8.maxIterations = a7;
        a8.run();
    }

    public final void run() {
        int a2;
        Polynomial a3 = this.kPoly;
        boolean a4 = false;
        double a5 = 0.0;
        double a6 = this.initialU;
        double a7 = this.initialV;
        double a8 = 0.0;
        int n = a2 = 0;
        JtVariableShiftQuadratic jtVariableShiftQuadratic = this;
        while (n < jtVariableShiftQuadratic.maxIterations) {
            int a9;
            double[] dArray = new double[3];
            dArray[0] = 1.0;
            dArray[1] = a6;
            dArray[2] = a7;
            NumberList a10 = this.quadratic.solve(new Polynomial(dArray));
            Complex a11 = null;
            Complex a12 = null;
            if (NumberUtils.isReal((Number)a10.get(0))) {
                if (Math.abs(((Number)a10.get(0)).doubleValue()) < Math.abs(((Number)a10.get(1)).doubleValue())) {
                    a11 = new Complex(((Number)a10.get(0)).doubleValue());
                    a12 = new Complex(((Number)a10.get(1)).doubleValue());
                } else {
                    a11 = new Complex(((Number)a10.get(1)).doubleValue());
                    a12 = new Complex(((Number)a10.get(0)).doubleValue());
                }
            } else {
                a11 = (Complex)a10.get(0);
                a12 = (Complex)a10.get(1);
            }
            if (Math.abs(Math.abs(a11.real) - Math.abs(a12.real)) > 0.01 * Math.abs(a12.real)) break;
            QuadraticSyntheticDivision a13 = new QuadraticSyntheticDivision(this.pPoly, a6, a7);
            Polynomial a14 = a13.quotient();
            double a15 = a13.b();
            double a16 = a13.a();
            double a17 = -(a11.real * a15);
            double a18 = Math.abs(a17 + a16);
            double a19 = a18 + Math.abs(a11.imaginary * a15);
            double a20 = Math.sqrt(Math.abs(a7));
            double a21 = 2.0 * Math.abs(a14.getCoefficient(0));
            int n2 = a9 = 1;
            while (n2 < a14.degree) {
                a21 = a21 * a20 + Math.abs(a14.getCoefficient(a9));
                n2 = ++a9;
            }
            a21 = a21 * a20 + a18;
            if (a19 <= 20.0 * (a21 = (9.0 * a21 + 2.0 * Math.abs(a17) - 7.0 * (a18 + a20 * Math.abs(a15))) * Constant.MACH_EPS)) {
                this.zeros.addAll(a10);
                this.deflatedPoly = a14;
                break;
            }
            JtUtils.VarSet a22 = null;
            if (a2 > 0 && a8 <= 0.01 && a19 >= a5 && !a4) {
                int a23;
                a8 = a8 < Constant.MACH_EPS ? Math.sqrt(Constant.MACH_EPS) : Math.sqrt(a8);
                a6 -= a6 * a8;
                a7 += a7 * a8;
                a13 = new QuadraticSyntheticDivision(this.pPoly, a6, a7);
                a14 = a13.quotient();
                a15 = a13.b();
                a16 = a13.a();
                int n3 = a23 = 0;
                while (true) {
                    if (n3 >= 5) break;
                    a22 = JtUtils.getScalarsForNextK(a3, a15, a16, a6, a7);
                    a3 = JtUtils.getNextK(a3, a14, a22);
                    n3 = ++a23;
                }
                a4 = true;
                a2 = 0;
            }
            if (a2 + 1 < this.maxIterations) {
                a5 = a19;
                a22 = JtUtils.getScalarsForNextK(a3, a15, a16, a6, a7);
                a3 = JtUtils.getNextK(a3, a14, a22);
                a22 = JtUtils.getScalarsForNextK(a3, a15, a16, a6, a7);
                double[] a24 = JtUtils.getUVEstimation(this.pPoly, a3, a22, a6, a7);
                double a25 = a24[0];
                double a26 = a24[1];
                if (a26 == 0.0) break;
                a8 = Math.abs((-a7 + a26) / a26);
                a6 = a25;
                a7 = a26;
            }
            n = ++a2;
            jtVariableShiftQuadratic = this;
        }
    }
}

