/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.Linear;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolynomialSolver;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.Quadratic;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JtFixedShift;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JtNoShift;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JtOriginZeros;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JtStep;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JtUtils;
import com.numericalmethod.suanshu.datastructure.list.NumberList;

public class JenkinsTraubReal
implements PolynomialSolver {
    private final Linear L = new Linear();
    private final Quadratic E = new Quadratic();

    @Override
    public NumberList solve(Polynomial polynomial) {
        NumberList a2 = new NumberList();
        Polynomial a3 = polynomial;
        Polynomial a4 = null;
        JtStep a5 = new JtOriginZeros(a3);
        a2.addAll(a5.getZeros());
        Polynomial polynomial2 = a3 = a5.getDeflatedPolynomial();
        while (true) {
            if (polynomial2.degree <= 2) break;
            a3 = JtUtils.getScaledPolynomialForAvoidingOverflowUnderflow(a3);
            a4 = new JtNoShift((Polynomial)a3, (int)5).kPoly;
            a5 = new JtFixedShift(a3, a4, this.E, 20);
            a2.addAll(a5.getZeros());
            polynomial2 = a3 = a5.getDeflatedPolynomial();
        }
        switch (a3.degree) {
            case 0: {
                break;
            }
            case 1: {
                a2.addAll(this.L.solve(a3));
                break;
            }
            case 2: {
                do {
                } while (false);
                a2.addAll(this.E.solve(a3));
                break;
            }
            default: {
                throw new RuntimeException("invalid degree: " + a3.degree);
            }
        }
        return a2;
    }

    @Override
    public PolynomialSolver.PolynomialType getType() {
        return PolynomialSolver.PolynomialType.GENERAL;
    }
}

