/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolynomialSolver;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class Linear
implements PolynomialSolver {
    @Override
    public NumberList solve(Polynomial polynomial) {
        Object[] objectArray = new Object[1];
        objectArray[0] = polynomial.degree;
        SuanShuUtils.assertArgument(polynomial.degree == 1, "a linear solver cannot solve for polynomial with degree %d", objectArray);
        double a2 = -polynomial.getCoefficient(1) / polynomial.getCoefficient(0);
        Number[] numberArray = new Number[1];
        numberArray[0] = new Double(a2);
        return new NumberList(numberArray);
    }

    @Override
    public PolynomialSolver.PolynomialType getType() {
        return PolynomialSolver.PolynomialType.LINEAR;
    }
}

