/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;

public class QuadraticSyntheticDivision {
    private final Polynomial i;
    private Polynomial G = null;
    private final double F;
    private double k;
    private double L;
    private final double E;

    public double b() {
        return this.k;
    }

    public Polynomial quotient() {
        return this.G;
    }

    public QuadraticSyntheticDivision(Polynomial polynomial, double u, double v) {
        if (polynomial.degree < 2) {
            throw new IllegalArgumentException("degree must be at least 2");
        }
        this.i = polynomial;
        this.E = u;
        this.F = v;
        this.m();
    }

    public double a() {
        return this.L;
    }

    private void m() {
        int a2;
        QuadraticSyntheticDivision a3;
        double[] a4 = a3.i.getCoefficients();
        double a5 = 0.0;
        double a6 = 0.0;
        double[] a7 = new double[a4.length - 2];
        a4[0] = a5 = a4[0];
        a4[1] = a6 = a4[1] - a5 * a3.E;
        int n = a2 = 2;
        while (n < a4.length) {
            a4[a2] = a4[a2] - a5 * a3.F - a6 * a3.E;
            a5 = a6;
            a6 = a4[a2];
            n = ++a2;
        }
        System.arraycopy(a4, 0, a7, 0, a7.length);
        a3.G = new Polynomial(a7);
        a3.k = a5;
        a3.L = a6;
    }
}

