/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;

public class HornerScheme {
    private final Polynomial F;
    private Polynomial k;
    private double L;
    private final double E;

    public Polynomial quotient() {
        return this.k;
    }

    public double remainder() {
        return this.L;
    }

    public HornerScheme(Polynomial polynomial, double x) {
        if (polynomial.degree < 1) {
            throw new IllegalArgumentException("degree must be at least 1");
        }
        this.F = polynomial;
        this.E = x;
        this.b();
    }

    private void b() {
        int a2;
        HornerScheme a3;
        double[] a4 = a3.F.getCoefficients();
        double[] a5 = new double[a4.length - 1];
        int n = a2 = 1;
        while (n < a4.length) {
            a4[a2] = a4[a2 - 1] * a3.E + a4[a2];
            n = ++a2;
        }
        a3.L = a4[a3.F.degree];
        System.arraycopy(a4, 0, a5, 0, a5.length);
        a3.k = new Polynomial(a5);
    }
}

