/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.multivariate;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class BorderedHessian
extends SymmetricMatrix {
    public final RealScalarFunction g;

    public BorderedHessian(RealScalarFunction f2, RealScalarFunction g2, Vector x) {
        this(f2, g2, x.toArray());
    }

    public BorderedHessian(RealScalarFunction f2, RealScalarFunction g2, double ... x) {
        super(f2.dimensionOfDomain() + 1);
        int a2;
        this.g = g2;
        SuanShuUtils.assertArgument(f2.dimensionOfDomain() == g2.dimensionOfDomain(), "f and g must have the same dimension for the domains", new Object[0]);
        int n = a2 = 2;
        while (n <= this.nRows()) {
            int[] nArray = new int[1];
            nArray[0] = a2 - 1;
            FiniteDifference a3 = new FiniteDifference(g2, nArray);
            double a4 = a3.evaluate(x);
            super.set(1, a2, a4);
            n = ++a2;
        }
        int n2 = a2 = 2;
        while (n2 <= this.nRows()) {
            int n3 = a2;
            while (n3 <= this.nCols()) {
                int a5;
                int[] nArray = new int[2];
                nArray[0] = a2 - 1;
                nArray[1] = a5 - 1;
                FiniteDifference a6 = new FiniteDifference(f2, nArray);
                double a7 = a6.evaluate(x);
                super.set(a2, a5, a7);
                n3 = ++a5;
            }
            n2 = ++a2;
        }
    }

    public double discriminant() {
        return MatrixMeasure.det(this);
    }
}

