/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.BivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.interpolation.NevilleTable;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class Ridders
implements RealScalarFunction {
    public final double rate;
    public final int order;
    public final RealScalarFunction f;
    public static final int N_POINTS_4_EXTRAPOLATION = 15;
    private NevilleTable L;
    private RealScalarFunction E;
    public final int nPoints4Extrapolation;

    public double evaluate(double[] x, double h2) {
        int a2;
        double a3 = h2;
        double[] dArray = Arrays.copyOf(x, x.length + 1);
        double[] a4 = dArray;
        dArray[a4.length - 1] = a3;
        double a5 = this.E.evaluate(a4);
        this.L = new NevilleTable();
        double[] dArray2 = new double[1];
        dArray2[0] = a3;
        double[] dArray3 = new double[1];
        dArray3[0] = a5;
        this.L.addData(dArray2, dArray3);
        double a6 = a5;
        double a7 = Double.MAX_VALUE;
        double a8 = a3;
        int n = a2 = 2;
        while (n <= this.nPoints4Extrapolation) {
            a8 *= this.rate;
            double[] dArray4 = Arrays.copyOf(x, x.length + 1);
            a4 = dArray4;
            dArray4[a4.length - 1] = a8;
            double a9 = this.E.evaluate(a4);
            double[] dArray5 = new double[1];
            dArray5[0] = a8;
            double[] dArray6 = new double[1];
            dArray6[0] = a9;
            this.L.addData(dArray5, dArray6);
            this.L.evaluate(0.0);
            int n2 = a2 - 2;
            while (n2 >= 0) {
                double d2;
                int a10;
                double a11 = this.L.get(a10, a2 - 1);
                double a12 = Math.abs(a11 - this.L.get(a10, a2 - 2));
                double a13 = Math.abs(a11 - this.L.get(a10 + 1, a2 - 1));
                double a14 = Math.max(a12, a13);
                if (d2 < a7) {
                    a6 = a11;
                    a7 = a14;
                }
                n2 = --a10;
            }
            if (Math.abs(a9 - this.L.get(a2 - 2, a2 - 2)) > 2.0 * a7) break;
            n = ++a2;
        }
        return a6;
    }

    @Override
    public double evaluate(double ... x) {
        double a2 = new DenseVector(x).norm();
        double a3 = 15.0 * Math.pow(Constant.EPSILON, 1.0 / (double)(this.order + 1)) * Math.max(0.1, a2);
        return this.evaluate(x, a3);
    }

    public Ridders(final RealScalarFunction f2, final int[] varidx, double rate, int nPoints4Extrapolation) {
        this.f = f2;
        this.order = varidx.length;
        this.rate = rate;
        this.nPoints4Extrapolation = nPoints4Extrapolation;
        this.E = new RealScalarFunction(){
            public com.numericalmethod.suanshu.analysis.differentiation.multivariate.FiniteDifference df;
            {
                2 a2;
                a2.df = new com.numericalmethod.suanshu.analysis.differentiation.multivariate.FiniteDifference(a2.f2, a2.varidx);
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }

            @Override
            public int dimensionOfDomain() {
                return f2.dimensionOfDomain() + 1;
            }

            @Override
            public double evaluate(double ... z2) {
                double a2 = z2[z2.length - 1];
                double[] a3 = Arrays.copyOfRange(z2, 0, z2.length - 1);
                return this.df.evaluate(a3, a2);
            }
        };
    }

    public Ridders(final UnivariateRealFunction f2, final int order, double rate, int nPoints4Extrapolation) {
        SuanShuUtils.assertArgument(order > 0, "the order of derivative must be >= 1", new Object[0]);
        this.f = f2;
        this.order = order;
        this.rate = rate;
        this.nPoints4Extrapolation = nPoints4Extrapolation;
        this.E = new BivariateRealFunction(){
            public FiniteDifference df;
            {
                1 a2;
                a2.df = new FiniteDifference(a2.f2, a2.order, FiniteDifference.FiniteDifferenceType.CENTRAL);
            }

            @Override
            public double evaluate(double x, double h2) {
                double[] dArray = new double[1];
                dArray[0] = x;
                return this.df.evaluate(dArray, h2);
            }

            @Override
            public double evaluate(double ... z2) {
                double a2 = z2[0];
                double a3 = z2[1];
                double[] dArray = new double[1];
                dArray[0] = a2;
                return this.df.evaluate(dArray, a3);
            }
        };
    }

    public Ridders(UnivariateRealFunction f2, int order) {
        this(f2, order, 0.75, 15);
    }

    public Ridders(RealScalarFunction f2, int[] varidx) {
        this(f2, varidx, 0.75, 15);
    }

    @Override
    public int dimensionOfDomain() {
        return this.f.dimensionOfDomain();
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }
}

