// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   JTextLabel.java

package lt.monarch.swing;

import java.awt.*;
import javax.swing.JComponent;

public class JTextLabel extends JComponent
{

    public void setHorizontalAlignment(int i)
    {
        alignment = i;
    }

    public void setText(String s)
    {
        int i = 1;
        for (int j = 0; j < s.length(); j++)
            if (s.charAt(j) == '\n')
                i++;

        text = new String[i];
        for (int k = 0; k < i; k++)
            text[k] = new String();

        i = 0;
        for (int l = 0; l < s.length(); l++)
            switch (s.charAt(l))
            {
            case 10: // '\n'
                i++;
                break;

            case 11: // '\013'
            case 12: // '\f'
            default:
                text[i] += s.charAt(l);
                break;

            case 13: // '\r'
                break;
            }

        invalidate();
    }

    public Dimension getMinimumSize()
    {
        return getPreferredSize();
    }

    public Dimension getPreferredSize()
    {
        FontMetrics fontmetrics = getToolkit().getFontMetrics(getFont());
        int i = 0;
        for (int j = 0; j < text.length; j++)
            i = Math.max(i, fontmetrics.stringWidth(text[j]));

        return new Dimension(i + fontmetrics.getAscent(), text.length * fontmetrics.getHeight() + fontmetrics.getLeading());
    }

    public void paintComponent(Graphics g)
    {
        if (isOpaque())
        {
            g.setColor(getBackground());
            g.fillRect(0, 0, getWidth(), getHeight());
        }
        Rectangle rectangle = getBounds();
        g.setColor(getForeground());
        FontMetrics fontmetrics = g.getFontMetrics();
        int i = fontmetrics.getAscent() / 2;
        for (int j = 0; j < text.length; j++)
        {
            int k = j * fontmetrics.getHeight() + fontmetrics.getAscent();
            if (text[j] != null)
                switch (alignment)
                {
                case 3: // '\003'
                    g.drawString(text[j], rectangle.width - fontmetrics.stringWidth(text[j]) - i, k);
                    break;

                case 2: // '\002'
                    g.drawString(text[j], i, k);
                    break;

                case 1: // '\001'
                    g.drawString(text[j], (rectangle.width - fontmetrics.stringWidth(text[j])) / 2, k);
                    break;
                }
        }

    }

    public JTextLabel()
    {
        this(2);
    }

    public JTextLabel(int i)
    {
        text = new String[0];
        alignment = i;
    }

    public JTextLabel(String as[], int i)
    {
        alignment = i;
        text = as;
    }

    public JTextLabel(String as[])
    {
        this(as, 2);
    }

    public JTextLabel(String s, int i)
    {
        alignment = i;
        setText(s);
    }

    public JTextLabel(String s)
    {
        this(s, 2);
    }

    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    protected String text[];
    protected int alignment;
}
