// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   Chart.java

package lt.monarch.charts;

import java.awt.*;
import java.util.Vector;
import lt.monarch.awt.Tooltip;

// Referenced classes of package lt.monarch.charts:
//            ChartSeries, Grid, XAxis, YAxis

public class Chart extends Panel
{
	private static final long serialVersionUID = 1L;
	public Chart()
    {
        setBackground(Color.white);
        setLayout(new FlowLayout());
        tip = new Tooltip();
        add(tip);
    }

    public synchronized Rectangle chartArea(Graphics g)
    {
        if (chartArea != null && bounds != null && bounds.equals(bounds()))
        {
            return chartArea;
        } else
        {
            bounds = bounds();
            int i = axisR == null ? 0 : axisR.width(g);
            int j = axisL == null ? 0 : axisL.width(g);
            int k = axisB.height(g);
            chartArea = new Rectangle(10 + j, 10, bounds.width - j - i - 20, bounds.height - k - 20);
            return chartArea;
        }
    }

    public boolean mouseExit(Event event, int i, int j)
    {
        tip.hide();
        return true;
    }

    public boolean mouseMove(Event event, int i, int j)
    {
        if (series == null)
            return true;
        //Object obj = null;
        String s = null;
        Point point = new Point(i, j);
        for (int k = series.size() - 1; k >= 0 && s == null; k--)
        {
            ChartSeries chartseries = (ChartSeries)series.elementAt(k);
            s = chartseries.tipAt(point);
        }

        if (s == null)
            tip.hide();
        else
        if (lastTip == null || !lastTip.equals(s))
            tip.showTip(s, point);
        lastTip = s;
        return true;
    }

    public void paint(Graphics g)
    {
        if (series == null)
            return;
        Rectangle rectangle = chartArea(g);
        if (axisB != null)
            axisB.draw(g, new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, bounds.height - rectangle.height - rectangle.y - 10));
        if (axisL != null)
            axisL.draw(g, new Rectangle(10, rectangle.y, rectangle.x - 10, rectangle.height));
        if (axisR != null)
            axisR.draw(g, new Rectangle(rectangle.x + rectangle.width, rectangle.y, bounds.width - rectangle.x - rectangle.width - 10, rectangle.height));
        if (grid != null)
            grid.draw(g, rectangle);
        for (int i = 0; i < series.size(); i++)
            ((ChartSeries)series.elementAt(i)).draw(g, rectangle);

        super.paintComponents(g);
    }

    public void setGrid(Grid grid1)
    {
        grid = grid1;
        chartArea = null;
    }

    public void setLeftAxis(YAxis yaxis)
    {
        axisL = yaxis;
        axisL.alignRight = true;
        chartArea = null;
    }

    public void setRightAxis(YAxis yaxis)
    {
        axisR = yaxis;
        axisR.alignRight = false;
        chartArea = null;
    }

    public void setXAxis(XAxis xaxis)
    {
        axisB = xaxis;
        chartArea = null;
    }

    public void setup(Vector<?> vector)
    {
        series = vector;
        axisB = null;
        axisL = null;
        axisR = null;
        grid = null;
        chartArea = null;
    }

    protected final int border = 10;
    protected Tooltip tip;
    protected String lastTip;
    protected Rectangle chartArea;
    protected Rectangle bounds;
    protected Vector<?> series;
    protected XAxis axisB;
    protected YAxis axisL;
    protected YAxis axisR;
    protected Grid grid;
}
