// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   NormalizedRange.java

package lt.monarch.chart;


public class NormalizedRange
{

    public final double range()
    {
        return max - min;
    }

    public final double min()
    {
        return min;
    }

    public final double max()
    {
        return max;
    }

    public final double step()
    {
        return step;
    }

    public final int steps()
    {
        return steps + 1;
    }

    public void setRange(double d, double d1)
    {
        minR = min = d;
        maxR = max = d1;
    }

    public boolean updateRange(double d)
    {
        if (maxR < d)
            maxR = d;
        if (minR > d)
            minR = d;
        return max < d || min > d;
    }

    public void normalize()
    {
        normalize(2, 10);
    }

    public void normalize(int i)
    {
        normalize(i / 2, i * 5);
    }

    protected void normalize(int i, int j)
    {
        if (minR == 1.7976931348623157E+308D || maxR == Double.MIN_VALUE)
        {
            steps = 0;
            step = 0.0D;
            min = 0.0D;
            max = 1.0D;
            return;
        }
        min = minR;
        max = maxR;
        double ad[] = {
            2D, 5D
        };
        int k = 0;
        step = 1.0D;
        precisionPlaces = 0;
        double d = max - min;
        if (d == 0.0D)
        {
            min = 0.0D;
            max = max + 1.0D;
            d = max - min;
        }
        do
        {
            while (d / step <= (double)i) 
            {
                step /= ad[k];
                k = 1 - k;
                precisionPlaces += k;
            }
            if (d / step <= (double)j)
                break;
            precisionPlaces -= k;
            k = 1 - k;
            step *= ad[k];
        } while (true);
        precision = 1.0D;
        for (int l = 0; l < precisionPlaces; l++)
            precision /= 10D;

        for (int i1 = 0; i1 < -precisionPlaces; i1++)
            precision *= 10D;

        double d1 = precision / 100D;
        min = (double)Math.round(min / d1) * d1;
        max = (double)Math.round(max / d1) * d1;
        min = Math.floor(min / step) * step;
        max = Math.ceil(max / step) * step;
        d = max - min;
        steps = (int)Math.round(d / step);
        step = d / (double)steps;
    }

    public String format(double d)
    {
        if (step < 1.0D)
        {
            d = (double)Math.round(d / precision) * precision;
            String s = String.valueOf(d);
            if (s.indexOf('E') > 0)
                return s;
            int i = precisionPlaces + 1 + (new Integer(Math.abs((int)d))).toString().length();
            if (d < 0.0D)
                i++;
            return s.length() <= i ? s : s.substring(0, i);
        } else
        {
            return String.valueOf((int)d);
        }
    }

    public String formatPrecise(double d)
    {
        if (step < 10D)
        {
            double d1 = precision / 100D;
            d = (double)Math.round(d / d1) * d1;
            String s = String.valueOf(d);
            if (s.indexOf('E') > 0)
                return s;
            int i = precisionPlaces + 3 + (new Integer(Math.abs((int)d))).toString().length();
            if (d < 0.0D)
                i++;
            return s.length() <= i ? s : s.substring(0, i);
        } else
        {
            return String.valueOf((int)d);
        }
    }

    public double map(double d)
    {
        if (range() == 0.0D)
            return (double)0;
        else
            return (d - min) / range();
    }

    public NormalizedRange()
    {
        min = 1.7976931348623157E+308D;
        max = Double.MIN_VALUE;
        minR = 1.7976931348623157E+308D;
        maxR = Double.MIN_VALUE;
        step = 0.0D;
    }

    public NormalizedRange(double d, double d1)
    {
        min = 1.7976931348623157E+308D;
        max = Double.MIN_VALUE;
        minR = 1.7976931348623157E+308D;
        maxR = Double.MIN_VALUE;
        step = 0.0D;
        minR = min = d;
        maxR = max = d1;
    }

    private double min;
    private double max;
    private double minR;
    private double maxR;
    private double step;
    private int steps;
    private int precisionPlaces;
    private double precision;
}
