// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   AbstractChart.java

package lt.monarch.chart;

import java.awt.*;

// Referenced classes of package lt.monarch.chart:
//            Chart, ChartContainer, Projector

public abstract class AbstractChart
    implements Chart
{

    public void setBackground(Color color)
    {
        background = color;
    }

    public void refresh()
    {
        Graphics g = container.getGraphics();
        if (g != null)
        {
            paint(g);
            g.finalize();
        }
    }

    public void invalidate()
    {
        requestPreparation();
        container.repaint();
    }

    public void setContainer(ChartContainer chartcontainer, Rectangle rectangle)
    {
        container = chartcontainer;
        area = rectangle;
        requestPreparation();
    }

    protected void requestPreparation()
    {
        needPreparation = true;
    }

    protected void prepareChart(Graphics g)
    {
    }

    protected void preparePaint(Graphics g)
    {
        if (needPreparation)
        {
            needPreparation = false;
            prepareChart(g);
        }
    }

    public void paint(Graphics g)
    {
        preparePaint(g);
        if (background != null)
        {
            g.setColor(background);
            Rectangle rectangle = projector().getProjectionArea();
            g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public ChartContainer container()
    {
        return container;
    }

    public String tipAt(Point point)
    {
        return null;
    }

    public abstract Projector projector();

    public AbstractChart()
    {
        container = null;
        area = null;
        needPreparation = true;
        background = Color.white;
    }

    protected ChartContainer container;
    protected Rectangle area;
    protected boolean needPreparation;
    protected Color background;
}
