// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   DensityMap.java

package lt.monarch.chart.chart2D;

import java.awt.*;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import lt.monarch.chart.*;

public class DensityMap extends AbstractChartObject
{

    public DensityMap(PlainMapper plainmapper, NormalizedMatrix normalizedmatrix)
    {
        mapper = plainmapper;
        matrix = normalizedmatrix;
        setPalette(createDefaultPalette(128));
    }

    public static Color[] createDefaultPalette(int i)
    {
        Color acolor[] = new Color[i];
        float af[] = {
            0.46875F, 0.9765625F, 0.0390625F
        };
        float af1[] = {
            0.1757813F, 0.9375F, 0.9960938F
        };
        float af2[] = new float[3];
        for (int j = 0; j < i; j++)
        {
            float f = (float)j / (float)(i - 1);
            af2[0] = ((1.0F + af1[0]) - af[0]) * f + af[0];
            af2[1] = (af[1] - af1[1]) * f + af1[1];
            af2[2] = (af1[2] - af[2]) * f + af[2];
            if (af2[0] > 1.0F)
                af2[0]--;
            acolor[j] = Color.getHSBColor(af2[0], af2[1], af2[2]);
        }

        return acolor;
    }

    public static Color[] createGrayPalette(int i)
    {
        return createGrayPalette(i, 0.5F);
    }

    public static Color[] createGrayPalette(int i, float f)
    {
        Color acolor[] = new Color[i];
        for (int j = 0; j < i; j++)
        {
            float f1 = (float)j / (float)(i - 1) / 2.0F + f;
            int k = (int)(255F * f1);
            acolor[j] = new Color(k, k, k);
        }

        return acolor;
    }

    public void draw(Graphics g)
    {
        if (mapper == null)
            drawImageMap(g);
        else
            drawPolygonMap(g);
    }

    private void drawImageMap(Graphics g)
    {
        int i = matrix.resolutionX;
        int j = matrix.resolutionY;
        byte abyte0[] = new byte[i * j];
        byte abyte1[] = new byte[palette.length];
        byte abyte2[] = new byte[palette.length];
        byte abyte3[] = new byte[palette.length];
        for (int k = 0; k < palette.length; k++)
        {
            abyte1[k] = (byte)(palette[k].getRed() & 0xff);
            abyte2[k] = (byte)(palette[k].getGreen() & 0xff);
            abyte3[k] = (byte)(palette[k].getBlue() & 0xff);
        }

        for (int l = 0; l < abyte0.length; l++)
            abyte0[l] = 50;

        int i1 = 0;
        int j1 = palette.length - 1;
        for (int k1 = j - 1; k1 >= 0; k1--)
        {
            for (int l1 = 0; l1 < i; l1++)
                abyte0[i1++] = (byte)((int)(matrix.z[l1][k1] * (double)j1) & 0xff);

        }

        IndexColorModel indexcolormodel = new IndexColorModel(8, palette.length, abyte1, abyte2, abyte3);
        MemoryImageSource memoryimagesource = new MemoryImageSource(i, j, indexcolormodel, abyte0, 0, i);
        Image image = chart().container().getComponent().createImage(memoryimagesource);
        MediaTracker mediatracker = new MediaTracker(chart().container().getComponent());
        mediatracker.addImage(image, 0);
        try
        {
            mediatracker.waitForID(0);
        }
        catch (InterruptedException _ex)
        {
            return;
        }
        mediatracker.removeImage(image, 0);
        Rectangle rectangle = chart().projector().getProjectionArea();
        g.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        image.flush();
    }

    private void drawPolygonMap(Graphics g)
    {
        lt.monarch.chart.NormalizedPoint normalizedpoint = mapper.map(0.0D, 0.0D);
        Point point = new Point();
        double ad[] = new double[2];
        int ai[] = new int[4];
        int ai1[] = new int[4];
        double d = matrix.resolutionX;
        double d1 = matrix.resolutionY;
        int i = palette.length - 1;
        for (int j = 0; j < matrix.resolutionX; j++)
        {
            ad[0] = ((double)j - 0.0D) / d;
            ad[1] = ((double)j + 1.0D) / d;
            for (int k = 0; k < 2; k++)
            {
                Point point1 = chart().projector().project(mapper.map(ad[k], 0.0D, normalizedpoint), point);
                ai[2 + k] = point1.x;
                ai1[2 + k] = point1.y;
            }

            for (int l = 0; l < matrix.resolutionY; l++)
            {
                double d2 = ((double)l + 1.0D) / d1;
                ai[0] = ai[3];
                ai1[0] = ai1[3];
                ai[1] = ai[2];
                ai1[1] = ai1[2];
                for (int i1 = 0; i1 < 2; i1++)
                {
                    Point point2 = chart().projector().project(mapper.map(ad[i1], d2, normalizedpoint), point);
                    ai[2 + i1] = point2.x;
                    ai1[2 + i1] = point2.y;
                }

                g.setColor(palette[(int)(matrix.z[j][l] * (double)i)]);
                g.fillPolygon(ai, ai1, 4);
            }

        }

    }

    public void setPalette(Color acolor[])
    {
        palette = acolor;
    }

    protected PlainMapper mapper;
    protected NormalizedMatrix matrix;
    protected Color palette[];
}
