// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   MathImageSource.java

package lt.monarch.awt;

import java.awt.Color;
import java.awt.image.*;
import java.util.Enumeration;
import java.util.Vector;

public class MathImageSource
    implements ImageProducer
{

    public MathImageSource(int i, int j)
    {
        levelCount = 256;
        theConsumers = new Vector();
        colorModel = ColorModel.getRGBdefault();
        width = i;
        height = j;
        imageData = new double[i * j];
        pixels = new int[i * j * 10];
        createPalette();
    }

    public synchronized void addConsumer(ImageConsumer imageconsumer)
    {
        if (theConsumers.contains(imageconsumer))
            return;
        theConsumers.addElement(imageconsumer);
        try
        {
            initConsumer(imageconsumer);
            sendPixelsTo(imageconsumer);
            if (isConsumer(imageconsumer))
            {
                imageconsumer.imageComplete(3);
                return;
            }
        }
        catch (Exception _ex)
        {
            if (isConsumer(imageconsumer))
                imageconsumer.imageComplete(1);
        }
    }

    public void clear()
    {
        for (int i = 0; i < imageData.length; i++)
        {
            imageData[i] = 0.0D;
            pixels[i] = 0;
        }

        update();
    }

    private void createPalette()
    {
        palette = new int[levelCount];
        float af[] = {
            0.46875F, 0.9765625F, 0.0390625F
        };
        float af1[] = {
            0.1757813F, 0.9375F, 0.9960938F
        };
        float af2[] = new float[3];
        for (int i = 0; i < levelCount; i++)
        {
            float f = (float)i / (float)(levelCount - 1);
            af2[0] = ((1.0F + af1[0]) - af[0]) * f + af[0];
            af2[1] = (af[1] - af1[1]) * f + af1[1];
            af2[2] = (af1[2] - af[2]) * f + af[2];
            if (af2[0] > 1.0F)
                af2[0]--;
            palette[i] = Color.HSBtoRGB(af2[0], af2[1], af2[2]);
        }

    }

    private void initConsumer(ImageConsumer imageconsumer)
    {
        if (isConsumer(imageconsumer))
            imageconsumer.setDimensions(width, height);
        if (isConsumer(imageconsumer))
            imageconsumer.setColorModel(colorModel);
        if (isConsumer(imageconsumer))
            imageconsumer.setHints(30);
    }

    public synchronized boolean isConsumer(ImageConsumer imageconsumer)
    {
        return theConsumers.contains(imageconsumer);
    }

    public synchronized void refresh()
    {
        refreshPixels();
    }

    protected void refreshPixels()
    {
        int i = 0;
        double d = 2.2250738585072014E-308D;
        double d1 = 1.7976931348623157E+308D;
        for (int j = 0; j < imageData.length; j++)
        {
            if (d < imageData[j])
                d = imageData[j];
            if (d1 > imageData[j])
                d1 = imageData[j];
        }

        double d2 = d - d1;
        double d3 = Math.log(d2 + 1.0D);
        double d4 = levelCount - 1;
        for (int k = 0; k < height; k++)
        {
            for (int l = 0; l < width; l++)
            {
                double d5 = imageData[i] - d1;
                d5 = Math.log(d5 + 1.0D) / d3;
                pixels[i++] = palette[(int)(d5 * d4)];
            }

        }

    }

    public synchronized void removeConsumer(ImageConsumer imageconsumer)
    {
        theConsumers.removeElement(imageconsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageconsumer)
    {
    }

    private void sendPixelsTo(ImageConsumer imageconsumer)
    {
        if (isConsumer(imageconsumer))
            imageconsumer.setPixels(0, 0, width, height, colorModel, pixels, 0, width);
    }

    public void setLevelCount(int i)
    {
        levelCount = i;
        createPalette();
        refresh();
    }

    public void startProduction(ImageConsumer imageconsumer)
    {
        addConsumer(imageconsumer);
    }

    public synchronized void update()
    {
        ImageConsumer imageconsumer;
        for (Enumeration enumeration = theConsumers.elements(); enumeration.hasMoreElements(); imageconsumer.imageComplete(3))
        {
            imageconsumer = (ImageConsumer)enumeration.nextElement();
            sendPixelsTo(imageconsumer);
        }

    }

    protected double imageData[];
    protected int pixels[];
    protected int palette[];
    protected int width;
    protected int height;
    protected int levelCount;
    Vector theConsumers;
    ColorModel colorModel;
}
