// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   GMJ.java

package lt.ktu.gmj.ui;

import lt.ktu.gmj.GlobalTools;
import lt.ktu.gmj.Method;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.*;
import lt.ktu.gmj.*;
import lt.ktu.gmj.analysis.ResultAnalyzer;
import lt.ktu.gmj.propertySheet.Header;
import lt.ktu.gmj.propertySheet.PropertySheet;
import lt.monarch.debug.*;
import lt.monarch.swing.applet.AppletFrame;


// Referenced classes of package lt.ktu.gmj.ui:
//            Logo, Minimizer, MinimizerDirector, ResultSet, 
//            ResultSheet, ResultNotifyer

public class GMJ extends JApplet
    implements MinimizerDirector, Runnable
{
    
	private static final long serialVersionUID = 1L;

	protected final class AnalysisAction extends AbstractAction
    {
       
		private static final long serialVersionUID = 1L;

		public void actionPerformed(ActionEvent actionevent)
        {
            ResultAnalyzer resultanalyzer = null;
            try
            {
                resultanalyzer = (ResultAnalyzer)Class.forName(className).newInstance();
                resultanalyzer.prepare(results);
            }
            catch (Throwable throwable)
            {
                if (resultanalyzer != null)
                    resultanalyzer.dispose();
                enableControls();
                ErrorLog.defaultLog().log("Analysis could not be initialized", throwable);
            }
        }

        String className;

        public AnalysisAction(String s)
        {
            className = s;
            putValue("Name", GMJ.shortClassName(s));
        }
    }

	

    public GMJ()
    {
        GlobalTools.setApplet(this);
        method = null;
        methods = new Hashtable<String, Method>();
        task = null;
    }

    protected static String completeClassName(String s, String as[])
    {
        for (int i = 0; i < as.length; i++)
        {
            String s1 = as[i];
            if (s.equals(shortClassName(s1)))
                return s1;
        }

        return null;
    }

    protected void enableControls()
    {
        if (SwingUtilities.isEventDispatchThread())
        {
            run.setEnabled(minimizer == null || minimizer != null && minimizer.isSuspended());
            pause.setEnabled(minimizer != null && !minimizer.isSuspended());
            stop.setEnabled(minimizer != null);
            analysis.setEnabled(results != null);
            stop.setText("Stop");
            pages.setEnabledAt(0, minimizer == null);
            pages.setEnabledAt(1, minimizer == null);
            pages.setEnabledAt(2, method != null && task != null);
        } else
        {
            SwingUtilities.invokeLater(this);
        }
    }

    public String getAppletInfo()
    {
        return logo.getInfo();
    }

    public void init()
    {
        GlobalTools.setApplet(this);
        try
        {
            try
            {
            	taskNames =getParameter("TASKS");
            	if (taskNames == null)
            		taskNames = "lt.ktu.gmj.tasks.Sin";            	
            }
            catch (NullPointerException _ex){}
            try
            {
            	methodNames = getParameter("METHODS");
            	if (methodNames == null)
            		methodNames = "lt.ktu.gmj.methods.Bayes";
            }
            catch (NullPointerException _ex) {}
            try
            {
            	analysisNames = getParameter("ANALYSIS");
            	if (analysisNames == null)
            		analysisNames = "lt.ktu.gmj.analysis.Convergence";
            }
            catch (NullPointerException _ex) {}
            pages = new JTabbedPane();
            pages.setBackground(Color.white);
            getContentPane().setBackground(new Color(230, 230, 230));
            getContentPane().setLayout(new BorderLayout());
            getContentPane().add("Center", pages);
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new FlowLayout(2));
            jpanel.add(new JLabel("Select method and properties:"));
            methodChoice = new JComboBox();
            jpanel.add(methodChoice);
            methodProperties = new PropertySheet();
            JPanel jpanel1 = new JPanel();
            jpanel1.setLayout(new BorderLayout(4, 4));
            jpanel1.add("North", jpanel);
            jpanel1.add("Center", methodProperties);
            pages.addTab("Method", jpanel1);
            JPanel jpanel2 = new JPanel();
            jpanel2.setLayout(new FlowLayout(2));
            jpanel2.add(new JLabel("Select task and properties:"));
            taskChoice = new JComboBox();
            jpanel2.add(taskChoice);
            taskProperties = new PropertySheet();
            JPanel jpanel3 = new JPanel();
            jpanel3.setLayout(new BorderLayout(4, 4));
            jpanel3.add("North", jpanel2);
            jpanel3.add("Center", taskProperties);
            pages.add("Task", jpanel3);
            JPanel jpanel4 = new JPanel();
            jpanel4.setLayout(new GridLayout(1, 4));
            run = new JButton("Run");
            pause = new JButton("Pause");
            stop = new JButton("Stop");
            analysis = new JButton("Analysis");
            jpanel4.add(run);
            jpanel4.add(pause);
            jpanel4.add(stop);
            jpanel4.add(analysis);
            run.setForeground(Color.green);
            stop.setForeground(Color.red);
            resultProperties = new ResultSheet();
            JPanel jpanel5 = new JPanel();
            jpanel5.setLayout(new BorderLayout(4, 4));
            jpanel5.add("South", jpanel4);
            jpanel5.add("Center", resultProperties);
            pages.addTab("Operation", jpanel5);         
            loadClassChoice(methodChoice, parseClassList(methodNames));
            loadClassChoice(taskChoice, parseClassList(taskNames));
            methodChoice.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent actionevent)
                {
                    stop();
                    reloadMethod();
                }

            });
            taskChoice.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent actionevent)
                {
                    stop();
                    reloadTask();
                }

            });
            run.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent actionevent)
                {
                    if (minimizer != null)
                    {
                        minimizer.resumeMinimizer();
                    } else
                    {
                        if (results == null)
                        {
                            results = new ResultSet(method, task);
                            results.addObserver(resultProperties);
                        }
                        minimizer = new Minimizer(GMJ.this, results);
                        minimizer.startMinimizer();
                    }
                }

            });
            pause.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent actionevent)
                {
                    if (minimizer != null)
                        minimizer.suspendMinimizer();
                    run.setEnabled(true);
                }

            });
            stop.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent actionevent)
                {
                    if (minimizer != null)
                        run.setEnabled(false);
                    pause.setEnabled(false);
                    stop.setEnabled(false);
                    stop.setText("Wait...");
                    stop();
                }

            });
            analysis.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent actionevent)
                {
                    showAnalysisMenu();
                }

            });
            reloadMethod();
            reloadTask();
        }
        catch (Throwable throwable)
        {
            getContentPane().removeAll();
            ErrorLog.defaultLog().log("Initialization error", throwable);            
        }
    }

    protected static void loadClassChoice(JComboBox jcombobox, String as[])
    {
        for (int i = 0; i < as.length; i++)
        {        	
            String s = shortClassName(as[i]);
            jcombobox.addItem(s);        
        }

    }

    public static void main(String args[])
        throws ClassNotFoundException
    {
        System.out.println("Global Minimizer II For Java. Modestas Grybauskas 1999");
        if (args.length == 0)        	
            System.out.println("Syntax: java lt.ktu.gmj.ui.GMJ <task names> <method names> <analysis names>");
        if (args.length > 0)
            taskNames = args[1];
        if (args.length > 1)
            methodNames = args[2];
        if (args.length > 2){
            analysisNames = args[3];
            new AppletFrame(new GMJ(), "GMJ", new Dimension(800, 500));
        }
    }

    public void minimizationComplete()
    {
        minimizer = null;
        enableControls();
    }

    public void minimizerStateChanged()
    {
        enableControls();
    }

    protected static String[] parseClassList(String s)
    {
        int i = 0;
        for (int j = 0; j < s.length(); j++)
        {        	
            i++;
            j = s.indexOf('|', j);
            if (j == -1)
                j = s.length();        	
        }        

        if (s.length() == 0)
        	i = 0;        
        int k = 0;
        String as[] = new String[i];
        for (int l = 0; l < s.length(); l++)
        {        	
            int i1 = s.indexOf('|', l);
            if (i1 == -1)
                i1 = s.length();
            String s1 = s.substring(l, i1);
            as[k++] = s1;
            l = i1;       
        }   
        return as;
    }

    protected void reloadMethod()
    {
        String s = parseClassList(methodNames)[methodChoice.getSelectedIndex()];
        method = (Method)methods.get(s);
        methodProperties.removeAll();
        method = null;
        if (method == null)
            try
            {
                method = (Method)Class.forName(s).newInstance();
                methods.put(s, method);
            }
            catch (Throwable throwable)
            {
                enableControls();
                methodProperties.complete();
                ErrorLog.defaultLog().log("Method could not be initialized", throwable);
                return;
            }
        methodProperties.add(new Header("Property", "Value"));
        method.customize(methodProperties);
        methodProperties.complete();
        enableControls();
    }

    protected void reloadTask()
    {
        String s = parseClassList(taskNames)[taskChoice.getSelectedIndex()];
        taskProperties.removeAll();
        task = null;
        try
        {
            task = (Task)Class.forName(s).newInstance();
        }
        catch (Throwable throwable)
        {
            enableControls();
            taskProperties.complete();
            ErrorLog.defaultLog().log("Task could not be initialized", throwable);
            return;
        }
        taskProperties.add(new Header("Property", "Value"));
        task.customize(taskProperties);
        task.domain().customize(taskProperties);
        taskProperties.complete();
        enableControls();
    }

    protected void removeLogo()
    {
        if (logo != null)
        {
            remove(logo);
            logo = null;
            validate();
        }
    }

    public void run()
    {
        enableControls();
    }

    protected static final String shortClassName(String s)
    {
        return s.indexOf('.') != -1 ? s.substring(s.lastIndexOf('.') + 1) : s;
    }

    private void showAnalysisMenu()
    {
        jpopupmenu = new JPopupMenu("Analysis methods");
        String as[] = parseClassList(analysisNames);
        for (int i = 0; i < as.length; i++)
            jpopupmenu.add(new AnalysisAction(as[i]));

        if (task instanceof TaskWithAnalyzers)
            try
            {
                Class<?> aclass[] = ((TaskWithAnalyzers)task).analyzers();
                if (aclass != null)
                {
                    for (int j = 0; j < aclass.length; j++)
                        jpopupmenu.add(new AnalysisAction(aclass[j].getName()));

                }
            }
            catch (ClassNotFoundException _ex) { }
        jpopupmenu.show(analysis, 0, analysis.getBounds().height);
    }

    public void stop()
    {
        if (minimizer != null)
        {
            minimizer.stopMinimizer();
            try
            {
                minimizer.join();
            }
            catch (InterruptedException _ex) { }
            minimizer = null;
        }
        if (results != null)
        {
            results.dispose();
            results = null;
        }
        enableControls();
    }

    static final String logoText[] = {
        "Method algorithms by Jonas Mockus", "Design&Implementation by Modestas Grybauskas"
    };
    protected static String taskNames;
    protected static String methodNames;
    protected static String analysisNames;
    protected Logo logo;
    protected JTabbedPane pages;
    protected Method method;
    protected JComboBox methodChoice;
    protected PropertySheet methodProperties;
    protected Hashtable<String, Method> methods;    
    protected Task task;
    protected JComboBox taskChoice;
    protected PropertySheet taskProperties;
    protected JButton run;
    protected JButton pause;
    protected JButton stop;
    protected JButton analysis;
    protected Minimizer minimizer;
    protected ResultSet results;
    protected ResultSheet resultProperties;
    JPopupMenu jpopupmenu;

    static 
    {
        MultiLogEngine multilogengine = new MultiLogEngine();
        multilogengine.addLogEngine(new SwingListLogEngine());
        multilogengine.addLogEngine(new StdErrLogEngine());
        ErrorLog.setDefaultLog(new ErrorLog(multilogengine));
    }

}
