// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) space 
// Source File Name:   Spectrum.java

package lt.ktu.gmj.analysis;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import lt.ktu.gmj.*;
import lt.monarch.chart.*;
import lt.monarch.chart.chart2D.*;
import lt.monarch.swing.JChartPanel;

// Referenced classes of package lt.ktu.gmj.analysis:
//            ResultFrame, FrequencyMatrix

public class Spectrum extends ResultFrame
{
	private static final long serialVersionUID = 1L;

	protected void setupChart()
    {
        //Vector vector = new Vector();
        MathAxisMapper mathaxismapper = new MathAxisMapper();
        MathAxisMapper mathaxismapper1 = new MathAxisMapper();
        Axis2DX axis2dx = new Axis2DX(mathaxismapper1);
        Axis2DY axis2dy = new Axis2DY(mathaxismapper);
        Grid grid = new Grid(axis2dx, axis2dy);
        grid.setFillColor(null);
        spectrum = new FrequencyMatrix(iterationGrid, 60, mathaxismapper1, mathaxismapper);
        spectrumSeries = new DensityMap(null, spectrum);
        axis2dy.setLabel("f(x)");
        mathaxismapper.range.setRange(super.results.minValue(), super.results.maxValue());
        if (projection == 0)
        {
            axis2dx.setLabel("Iteration");
            mathaxismapper1.range.setRange(0.0D, super.results.method().iterations());
        } else
        {
            axis2dx.setLabel(super.results.task().domain().dimensions()[projection - 1]);
            mathaxismapper1.range.setRange(super.results.task().domain().min[projection - 1], super.results.task().domain().max[projection - 1]);
        }
        chart.reset();
        chart.setLAxis(axis2dy);
        chart.setXAxis(axis2dx);
        chart.setObjects(new ChartObject[] {
            axis2dx, axis2dy, spectrumSeries, grid
        });
        for (int i = 0; i < super.results.resultCount(); i++)
        {
            Result result = super.results.resultAt(i);
            if (projection == 0)
                spectrum.addPoint(new Double(result.iteration), new Double(result.value));
            else
                spectrum.addPoint(new Double(result.point.x[projection - 1]), new Double(result.value));
        }

        spectrum.refresh();
        chart.invalidate();
    }

    public void newResult(ResultRepository resultrepository)
    {
        Result result = super.results.lastResult();
        if (projection == 0)
            spectrum.addPoint(new Double(result.iteration), new Double(result.value));
        else
            spectrum.addPoint(new Double(result.point.x[projection - 1]), new Double(result.value));
        if (super.results.lastResult().iteration % iterationStep == 0)
            updateView();
    }

    public void newProgressResult(ResultRepository resultrepository)
    {
    }

    public void finalResult(ResultRepository resultrepository)
    {
        updateView();
    }

    protected void updateView()
    {
        spectrum.refresh();
        chart.invalidate();
    }

    @SuppressWarnings("deprecation")
	public void prepare(ResultRepository resultrepository)
    {
        super.prepare(resultrepository);
        iterationGrid = resultrepository.method().iterations() / 5 + 1;
        if (iterationGrid > 100)
            iterationGrid = 100;
        iterationStep = (resultrepository.method().iterations() / iterationGrid) * 5;
        if (iterationStep < 1)
            iterationStep = 1;
        projectionChoice.addItem("Iteration");
        String as[] = resultrepository.task().domain().dimensions();
        for (int i = 0; i < as.length; i++)
            projectionChoice.addItem(as[i]);

        setupChart();
        show();
        resultrepository.addObserver(this);
    }

    public void logStarted(ResultRepository resultrepository)
    {
        spectrum.clear();
        chart.invalidate();
    }

    public Spectrum()
    {
        super("Spectrum");
        projection = 0;
        chart = new Chart2D();
        getContentPane().add("Center", new JChartPanel(chart));
        projectionChoice = new JComboBox();
        getContentPane().add("South", projectionChoice);
        projectionChoice.addItemListener(new _cls1());
    }

    protected Chart2D chart;
    protected int iterationStep;
    protected int iterationGrid;
    protected FrequencyMatrix spectrum;
    protected ChartObject spectrumSeries;
    protected JComboBox projectionChoice;
    protected int projection;

    private class _cls1
        implements ItemListener
    {

        public void itemStateChanged(ItemEvent itemevent)
        {
            projection = projectionChoice.getSelectedIndex();
            setupChart();
        }

        public void constructor$0(Spectrum spectrum1)
        {
        }

        public _cls1()
        {
            constructor$0(Spectrum.this);
        }
    }

}
