import java.util.Vector;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ResultTable extends JTable{
	private Vector m_straColumnNames;
	
	public ResultTable(){
		super(0,0);
		m_straColumnNames = new Vector();
		addColumn("Pavadinimas".toUpperCase());
		addColumn("Kiekis".toUpperCase());
		addColumn("Vnt. kaina".toUpperCase());
		addColumn("Is viso".toUpperCase());
	}
	public void addColumn(String strColumnName){
		if( super.getModel() instanceof DefaultTableModel ){
			if(!m_straColumnNames.contains(strColumnName)){
				((DefaultTableModel)super.getModel()).addColumn(strColumnName);
				m_straColumnNames.addElement(strColumnName.toUpperCase());
			}
		}
	}
	public void addRow(){
		if( super.getModel() instanceof DefaultTableModel ){
			int cols = super.getModel().getColumnCount();
			((DefaultTableModel)super.getModel()).addRow(new Object[cols]);
		}
	}
	public void setData(int row, int col, String strData){
		((DefaultTableModel)super.getModel()).setValueAt(strData,row,col);
	}
	public void addRow(String col1, String col2, String col3){
		addRow();
		setData(super.getRowCount()-1,0,col1);
		setData(super.getRowCount()-1,1,col2);
		setData(super.getRowCount()-1,2,col3);
		setData(super.getRowCount()-1,3,Double.toString(Double.parseDouble(col2)*Double.parseDouble(col3)));
	}
	public void flushTable(){
		if( super.getModel() instanceof DefaultTableModel )
		{
			((DefaultTableModel)super.getModel()).setNumRows(0);
		}
		else
		{
			int cols = super.getModel().getColumnCount();
			super.setModel( new DefaultTableModel(0, cols) );
		}
	}
}
