import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

public class ProductTable extends JTable implements DataListener{
	private Vector m_straColumnNames;
	private JComboBox tastes;
	public ProductTable(){
		super(0,0);
		m_straColumnNames = new Vector();
		addColumn("Pavadinimas".toUpperCase());
		addColumn("Kaina".toUpperCase());
		addColumn("Skonis".toUpperCase());
		tastes = new JComboBox();
		tastes.addItem("Skanu");
		tastes.addItem("Nesvarbu");
		tastes.addItem("neskanu");
		this.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(tastes));
	}
	public void addRow(String strRowName){
		if( super.getModel() instanceof DefaultTableModel ){
			int cols = super.getModel().getColumnCount();
			((DefaultTableModel)super.getModel()).addRow(new Object[cols]);
			int iLastRow = super.getRowCount();
			if(iLastRow!=0){
					super.setValueAt(strRowName,iLastRow-1,0);
					for(int j = 1; j < m_straColumnNames.size(); j++){
						super.setValueAt("0",iLastRow-1,j);
					}
					
			}
		}
	}
	public void addRow(){
		if( super.getModel() instanceof DefaultTableModel ){
			int cols = super.getModel().getColumnCount();
			((DefaultTableModel)super.getModel()).addRow(new Object[cols]);
			
		}
	}
	public void addColumn(String strColumnName){
		if( super.getModel() instanceof DefaultTableModel ){
			if(!m_straColumnNames.contains(strColumnName)){
				((DefaultTableModel)super.getModel()).addColumn(strColumnName);
				m_straColumnNames.addElement(strColumnName);
				
			}
		}
	}
	public void getNewColumn(String strColumnName) {
		addColumn(strColumnName);
	}
	public void setData(int row, int col, String strData){
		((DefaultTableModel)super.getModel()).setValueAt(strData,row,col);
			
	}
	public void getData(String strColumnName, String strValue) {
		int col = m_straColumnNames.indexOf(strColumnName.toUpperCase());
		int row = super.getRowCount()-1;
		setData(row,col,strValue);
		setTaste("Nesvarbu",row);
	}
	public void getNewRow() {
		addRow();
	}
	public void flushTable(){
		if( super.getModel() instanceof DefaultTableModel )
		{
			((DefaultTableModel)super.getModel()).setNumRows(0);		
			((DefaultTableModel)super.getModel()).setColumnCount(0);
		}
		else
		{
			super.setModel( new DefaultTableModel(0, 0) );
		}
		m_straColumnNames.removeAllElements();
		addColumn("Pavadinimas".toUpperCase());
		addColumn("Kaina".toUpperCase());
		addColumn("Skonis".toUpperCase());
	}
	public void removeRow(int row){
		if( super.getModel() instanceof DefaultTableModel )
		{
			((DefaultTableModel)super.getModel()).removeRow(row);
		}
	}

	public void getData(int row, int col, String strValue) {
		if( super.getModel() instanceof DefaultTableModel )
		{
			((DefaultTableModel)super.getModel()).setValueAt(strValue,row,col);
		}
	}
	public String getData(int row, String strColName){
		return getValueByColumnName(row,strColName).toString();
	}
	public int getProductCount(){
		return super.getRowCount();
	}
	public int getRestrictionCount(){
		return (super.getColumnCount()-2); // minus name and price
	}
	public Vector getRestrictNames(){
		return m_straColumnNames;
	}
	public void saveToFile(JTextArea p){
		//FileOutputStream out;
    	//PrintStream p;
			//out = new FileOutputStream(strFileName);
			//p = new PrintStream( out );
			p.setText("");
            p.append("<?xml version=\"1.0\" encoding=\"windows-1257\"?>\n");
            p.append("<Meniu>\n");
            for(int i = 0; i < super.getRowCount(); i++){
            	p.append("<Produktas>\n");
            	for(int j = 0; j < super.getColumnCount(); j++){
            		p.append("<"+m_straColumnNames.elementAt(j).toString()+">"+super.getValueAt(i,j).toString()+"</"+m_straColumnNames.elementAt(j).toString()+">\n");
            	}
            	p.append("</Produktas>\n");
            }
            p.append("</Meniu>\n");
	}
	public int count(){
		return super.getRowCount();
	}
	public String getValueByColumnName(int row,String strName){
		int col = m_straColumnNames.indexOf(strName.toUpperCase());
		return super.getValueAt(row,col).toString();
	}
	public int getIdByProductName(String name){
		for(int i = 0; i < super.getRowCount(); i++){
			if(super.getValueAt(0,0).toString().toUpperCase().equals(name.toUpperCase()))
				return i;
		}
		return -1;
	}
	public void setTaste(String taste,String product){
		int row = getIdByProductName(product);
		super.setValueAt(taste,row,2);
	}
	public void setTaste(String taste,int id){
		super.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(tastes));
		super.setValueAt(taste,id,2);
	}
}
