import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class NutritionValuesTable extends JTable implements DataListener{
	private Vector m_straColumnNames;
	public NutritionValuesTable(){
		super(0,0);
		m_straColumnNames = new Vector();
		addColumn("Amzius".toUpperCase());
		addColumn("Lytis".toUpperCase());
		super.setRowSelectionAllowed(true);
		super.setColumnSelectionAllowed(true);
	}
	public void addRow(String strRowName){
		if( super.getModel() instanceof DefaultTableModel ){
			int cols = super.getModel().getColumnCount();
			((DefaultTableModel)super.getModel()).addRow(new Object[cols]);
			int iLastRow = super.getRowCount();
			if(iLastRow!=0){
					super.setValueAt(strRowName,iLastRow-1,0);
			}
		}
	}
	public void addRow(){
		if( super.getModel() instanceof DefaultTableModel ){
			int cols = super.getModel().getColumnCount();
			((DefaultTableModel)super.getModel()).addRow(new Object[cols]);
		}
	}
	public void addColumn(String strColumnName){
		if( super.getModel() instanceof DefaultTableModel ){
			if(!m_straColumnNames.contains(strColumnName)){
				((DefaultTableModel)super.getModel()).addColumn(strColumnName);
				m_straColumnNames.addElement(strColumnName.toUpperCase());
			}
		}
	}
	public void getNewColumn(String strColumnName) {
		addColumn(strColumnName);
	}
	public void setData(int row, int col, String strData){
		((DefaultTableModel)super.getModel()).setValueAt(strData,row,col);
	}
	public void getData(String strColumnName, String strValue) {
		int col = m_straColumnNames.indexOf(strColumnName.toUpperCase());
		int row = super.getRowCount()-1;
		setData(row,col,strValue);
	}
	public void getNewRow() {
		addRow();
	}
	public void flushTable(){
		if( super.getModel() instanceof DefaultTableModel )
		{
			((DefaultTableModel)super.getModel()).setNumRows(0);
			((DefaultTableModel)super.getModel()).setColumnCount(0);
		}
		else
		{
			super.setModel( new DefaultTableModel(0, 0) );
		}
		m_straColumnNames.removeAllElements();
		addColumn("Amzius".toUpperCase());
		addColumn("Lytis".toUpperCase());
	}
	public void removeRow(int row){
		if( super.getModel() instanceof DefaultTableModel ){
			((DefaultTableModel)super.getModel()).removeRow(row);
		}
	}
	public String getDataString(String strGender, String strAge, String strWeight){
		String strRow = "";
		int cols = super.getModel().getColumnCount();
		int row = getRowByAgeGenderWeight(strGender, strAge, strWeight);
		if(row != -1){
			for(int i = 0; i < cols; i++){
				//sParameters.addElement(new Parameter(super.getModel().getColumnName(i),Float.parseFloat(super.getModel().getValueAt(row,i).toString())));
				strRow +=  super.getModel().getColumnName(i) + " " + super.getModel().getValueAt(row,i) + " \n";
			}
		}
		else{
			strRow = "Duomenu nerasta";
		}
		return strRow;
	}
	public Vector getDataVector(String strGender, String strAge, String strWeight){
		String strRow = "";
		Vector sParameters = new Vector();
		int cols = super.getModel().getColumnCount();
		int row = getRowByAgeGenderWeight(strGender, strAge, strWeight);
		if(row != -1){
			for(int i = 0; i < cols; i++){
				sParameters.addElement(new Parameter(super.getModel().getColumnName(i),super.getModel().getValueAt(row,i).toString()));
				strRow +=  super.getModel().getColumnName(i) + " " + super.getModel().getValueAt(row,i) + " \n";
			}
		}
		else{
			System.out.println("Duomenu nerasta");
		}
		return sParameters;
	}
	public Parameter getNormByName(String strGender, String strAge, String strName, String strWeight){
		Vector v = getDataVector(strGender, strAge, strWeight);
		int col = m_straColumnNames.indexOf(strName.toUpperCase());
		//printAllColumns();
		return (Parameter)v.elementAt(col);
	}
	public int getRowByAgeGenderWeight(String strGender, String strAge, String strWeight){
		for(int i = 0; i<super.getModel().getRowCount(); i++){
			if(getValueByName(i,"amzius").equals(strAge) && getValueByName(i,"lytis").equals(strGender) && getValueByName(i,"SVORIS").equals(strWeight)){
				return i;
			}
		}
		return -1;
	}
	public void getData(int row, int col, String strValue) {
		// TODO Auto-generated method stub
		
	}
	public Vector getAgeList(){
		Vector ages = new Vector();
		for(int i = 0; i < super.getRowCount(); i++){
			if(!ages.contains(super.getModel().getValueAt(i,0))){
				ages.addElement(getValueByName(i,"Amzius"));
			}
		}
		return ages;
	}
	public Vector getFemaleWeigthList(){
		Vector weights = new Vector();
		for(int i = 0; i < super.getRowCount(); i++){
			if(!weights.contains(getValueByName(i,"Svoris")) && getValueByName(i,"Lytis").toUpperCase().equals("M")){
				weights.addElement(getValueByName(i,"Svoris"));
			}
		}
		return weights;
	}
	public Vector getMaleWeigthList(){
		Vector weights = new Vector();
		for(int i = 0; i < super.getRowCount(); i++){
			if(!weights.contains(getValueByName(i,"Svoris")) && getValueByName(i,"Lytis").toUpperCase().equals("V")){
				weights.addElement(getValueByName(i,"Svoris"));
			}
		}
		return weights;
	}
	public void printAllColumns(){
		for(int i = 0; i < m_straColumnNames.size(); i++){
			System.out.print(m_straColumnNames.elementAt(i).toString()+" ");
		}
		System.out.println();
	}
	public int count(){
		return super.getRowCount();
	}
	public String getValueByName(int row, String colName){
		int col = m_straColumnNames.indexOf(colName.toUpperCase());
		if(col!=-1 && super.getValueAt(row,col)!=null)
			return super.getValueAt(row,col).toString();
		return "";
	}
	public Vector getRestrictNames(){
		return m_straColumnNames;
	}
}
