import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import lp.constant;
import lp.lprec;
import lp.solve;
//import lp.*;

public class JResultPanel extends JPanel implements constant, ActionListener{
	private JParameterPanel parameters;
	private JDataPanel data;
	private JButton m_btnCalc;
	private ResultTable m_tblResults;
	private JScrollPane m_panelScroll;
	private JLabel m_lblSuma;

	public JResultPanel(){
		m_btnCalc = new JButton("Skaiciuoti");
		m_tblResults = new ResultTable();
		m_panelScroll = new JScrollPane(m_tblResults);
		m_lblSuma = new JLabel("Is viso: ");
		super.setLayout(new BorderLayout());
		super.add(m_btnCalc, BorderLayout.NORTH);
		super.add(m_panelScroll, BorderLayout.CENTER);
		super.add(m_lblSuma,BorderLayout.SOUTH);
		m_btnCalc.addActionListener(this);
	}
	public void setParameters(JParameterPanel param){
		parameters = param;
	}
	public void setData(JDataPanel dat){
		data = dat;
	}
	public void calculate(){
		String strRez;
		Vector productNames = data.getRestrictNames(); 
		Vector restrictNames = parameters.getRestrictNames();
		int totalProducts = data.getProductCount();
		int restrict = data.getRestrictionCount();
		solve lpSolve = new solve(); // sprendimo klase
		lprec lpIn = new lprec(0,totalProducts);
		double v[] = new double[totalProducts+1];
		double r[] = new double[restrict+1]; 
		
		m_tblResults.flushTable();
		m_lblSuma.setText("Is viso: ");
		// minimizuojame islaidas
		for(int i = 0; i < totalProducts; i++){
			v[i+1] = Double.parseDouble(data.getValue(i,"Kaina").toString());
		}
		lpSolve.set_obj_fn(lpIn,v);
		lpSolve.set_minim(lpIn);
		
		//apribojimu ivedimas
		double a[][] = new double[restrict+1][totalProducts+1];
		for(int j = 0; j < restrict-2; j++){
			for(int i = 0; i < totalProducts; i++){
				a[j+1][i+1] = Double.parseDouble(data.getValueByColumnName(i,restrictNames.elementAt(j+3).toString()).toString());
				
				//System.out.print(a[j+1][i+1]+" ");
			}
			//System.out.println(restrictionNames.elementAt(j+2).toString());
			
			Parameter param = parameters.getNormByName(restrictNames.elementAt(j+3).toString());
			r[j+1] = Double.parseDouble(param.Value());
			
			lpSolve.add_constraint(lpIn,a[j+1],GE,r[j+1]);
			lpSolve.set_row_name(lpIn,j+1,restrictNames.elementAt(j+3).toString());
		}
		for(int j=0; j<totalProducts;j++){
			lpSolve.set_col_name(lpIn,j+1,data.getValueByColumnName(j,"Pavadinimas").toString());
		}
		double[] s;
		for(int i=0; i < totalProducts; i++){
			s = new double[totalProducts+1];
			if(data.getValueByColumnName(i,"Skonis").toString().equals("Skanu")){
				s[i+1]=1;
				lpSolve.add_constraint(lpIn,s,GE,1);
			}
			s = new double[totalProducts+1];
			if(data.getValueByColumnName(i,"Skonis").toString().equals("neskanu")){
				s[i+1]=1;
				lpSolve.add_constraint(lpIn,s,LE,0);
			}
		}
		int result = lpSolve.solve(lpIn);
		System.out.println(result);
		
        if (result == constant.OPTIMAL){
             strRez = "Minimali dietos kaina, Lt:"+Double.toString(lpIn.getBestSolution(0));
             m_lblSuma.setText("Is viso: "+Double.toString(lpIn.getBestSolution(0)));
             strRez = strRez + "\nProduktas\tKiekis";
             for (int i=0;i<lpIn.getColumns();i++){
            	 if(lpIn.getBestSolution(lpIn.getRows()+i+1)!=0){
            		 strRez = strRez + "\n"+data.getValueByColumnName(i,"Pavadinimas")+"\t"+Double.toString(lpIn.getBestSolution(lpIn.getRows()+i+1));
            		 m_tblResults.addRow(data.getValueByColumnName(i,"Pavadinimas"),Double.toString(lpIn.getBestSolution(lpIn.getRows()+i+1)),data.getValueByColumnName(i,"Kaina"));
            		 //System.out.println(lpIn.getBestSolution(lpIn.getRows()+i+1));
            		 
            	 }
             }
             lpSolve.print_lp(lpIn);
            //lpSolve.print_solution(lpIn);// cia galima pasiziureti, kaip galima
             //System.out.println(strRez);
        }
	}
	public void actionPerformed(ActionEvent event) {
		if(event.getActionCommand().equals("Skaiciuoti")){
			calculate();
		}
	}

}

