import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JParameterPanel extends JPanel implements ActionListener{
	private JPanel m_panelLoadFile;
	private JTextField m_fieldFilePath;
	private JButton m_btnLoad;
	private JScrollPane m_panelTableScroll;
	private NutritionValuesTable m_tblNutrition;
	private JPanel m_panelPersonalSettings;
	private JComboBox m_comboAge;
	private JLabel m_lblAge;
	private JRadioButton m_btnMale;
	private JRadioButton m_btnFemale;
	private ButtonGroup m_groupGender;
	private JPanel m_panelAge;
	private JPanel m_panelGender;
	private JPanel m_panelWeight;
	private JLabel m_lblGender;
	private JTextArea m_fieldSelectedParameters;
	private JScrollPane m_panelParameterScroll;
	private JComboBox m_comboWeight;
	private JLabel m_lblWeight;
	private MainApp m_main;
	private String CodeBase;
	public JParameterPanel(String strCodeBase){
		CodeBase = strCodeBase;
		m_tblNutrition = new NutritionValuesTable();
		m_panelTableScroll = new JScrollPane(m_tblNutrition);
		m_panelLoadFile = new JPanel();
		m_fieldFilePath = new JTextField(CodeBase);
		m_fieldFilePath.setColumns(20);
		m_btnLoad = new JButton("Uzkrauti duomenis");
		m_panelLoadFile.add(m_fieldFilePath);
		m_panelLoadFile.add(m_btnLoad);
		m_panelPersonalSettings = new JPanel();
		m_panelPersonalSettings.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
		m_comboAge = new JComboBox();
		m_comboWeight = new JComboBox();
		m_lblWeight = new JLabel("Svoris");
		m_lblAge = new JLabel("Amzius >=");
		m_lblGender = new JLabel("Lytis");
		m_btnMale = new JRadioButton("Vyr.");
		m_btnFemale = new JRadioButton("Mot.");
		m_groupGender = new ButtonGroup();
		
		m_fieldSelectedParameters = new JTextArea();
		m_fieldSelectedParameters.setEditable(false);
		m_fieldSelectedParameters.setFont(new Font( "Serif", Font.PLAIN, 12 ));
		m_fieldSelectedParameters.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Apribojimai"),BorderFactory.createEmptyBorder(1,1,1,1)));
		m_panelParameterScroll = new JScrollPane(m_fieldSelectedParameters);
		m_panelParameterScroll.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		m_fieldSelectedParameters.setRows(7);
		m_panelAge = new JPanel();
		m_panelAge.add(m_lblAge);
		m_panelAge.add(m_comboAge);
		m_panelGender = new JPanel();
		m_panelGender.add(m_lblGender);
		m_panelGender.add(m_btnMale);
		m_panelGender.add(m_btnFemale);
		m_groupGender.add(m_btnMale);
		m_groupGender.add(m_btnFemale);
		m_btnMale.setSelected(true);
		m_panelWeight = new JPanel();
		m_panelWeight.add(m_lblWeight);
		m_panelWeight.add(m_comboWeight);
		
		super.setLayout(new BorderLayout());
		super.add(m_panelLoadFile, BorderLayout.NORTH);
		super.add(m_panelTableScroll, BorderLayout.CENTER);
		super.add(m_panelPersonalSettings,BorderLayout.SOUTH);
		
		m_panelPersonalSettings.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		
		c.gridx = 0;
		c.gridy = 0;
		c.weightx = 1.0;
		c.anchor = GridBagConstraints.EAST;
		m_panelPersonalSettings.add(m_panelAge, c);
		c.gridx = 1;
		c.gridy = 0;
		c.weightx = 1.0;
		c.anchor = GridBagConstraints.CENTER;
		m_panelPersonalSettings.add(m_panelGender,c);
		c.gridx = 2;
		c.gridy = 0;
		c.weightx = 1.0;
		c.anchor = GridBagConstraints.WEST;
		m_panelPersonalSettings.add(m_panelWeight,c);
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridx = 0;
		c.gridy = 1;
		c.weightx = 1.0;
		c.gridwidth = 3;
		m_panelPersonalSettings.add(m_panelParameterScroll,c);
		//fillAgeCombo();
		m_comboAge.setActionCommand("Amzius");
		m_comboWeight.setActionCommand("Svoris");
		
		m_btnLoad.addActionListener(this);
		m_btnMale.addActionListener(this);
		m_btnFemale.addActionListener(this);
		

	}
	public void actionPerformed(ActionEvent event) {
		if(event.getActionCommand().equals("Uzkrauti duomenis")){
			//JFileChooser chooser = new JFileChooser();
			try {
				//chooser.setCurrentDirectory(new File(new File(".").getCanonicalPath()).getParentFile());
				//XMLFileFilter filter = new XMLFileFilter();
				//chooser.setFileFilter(filter);
				
				//int returnVal = chooser.showOpenDialog(this);
			    //if(returnVal == JFileChooser.APPROVE_OPTION) {		
			    	/*InputStream in = new FileInputStream(chooser
							.getCurrentDirectory()
							+ "\\" + chooser.getSelectedFile().getName());*/
				m_tblNutrition.flushTable();
				URL fileURL = new URL(m_fieldFilePath.getText());
				InputStream in = fileURL.openStream();
			    	if(loadXML(in)){
			    		//m_labelWarning.setText("Duomenys uzkrauti sekmingai");
			    	}
					in.close();
			    //}
					
			}
			catch (MalformedURLException e){
				
			}
			catch (IOException e) {
				//m_labelWarning.setText("Klaida nuskaitant duomenis");
				e.printStackTrace();
			}
			if(m_tblNutrition.count()>0){
				m_main.enable(2);
			}
			else 
				m_main.disable(2);
			
			if(m_btnMale.isSelected()){
				fillWithMaleWeight();
			}
			else{
				fillWithFemaleWeight();
			}
			if(m_comboWeight.getItemCount()>0){
				m_comboWeight.setSelectedIndex(0);
			}else
			{
				m_main.disable(2);
			}
			fillAgeCombo();
			m_comboWeight.addActionListener(this);

			m_comboAge.addActionListener(this);
			
	
		}

		if(event.getActionCommand().equals("Vyr.")){
			fillWithMaleWeight();
			m_comboWeight.setSelectedIndex(0);
			//showSelectedParameters();
		}
		if(event.getActionCommand().equals("Mot.")){
			fillWithFemaleWeight();
			m_comboWeight.setSelectedIndex(0);
			//showSelectedParameters();
		}
		if(event.getActionCommand().equals("Amzius")){
			showSelectedParameters();
		}
		if(event.getActionCommand().equals("Svoris")){
			if(m_comboWeight.getItemCount()>0)
				showSelectedParameters();
		}
	}
	public boolean loadXML(InputStream stream){
		InputSource source = new InputSource(stream);
	      try {
	    	
	    	XMLReader parser = XMLReaderFactory.createXMLReader();
	    	DataExtractor handler = new DataExtractor();
	    	parser.setContentHandler(handler);
	    	
	    	handler.addDataListener(m_tblNutrition);
			parser.parse(source);
			handler.removeDataListener(m_tblNutrition);
		} catch (SAXException e) {
			System.out.println("document is not well-formed");		
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	private void fillAgeCombo(){
		Vector ages = m_tblNutrition.getAgeList();
		for(int i = 0; i < ages.size(); i++){
			m_comboAge.insertItemAt(ages.elementAt(i).toString(),i);
		}
		m_comboAge.setSelectedIndex(0);
	}
	private void showSelectedParameters(){
		String strAge = m_comboAge.getSelectedItem().toString();
		String strGender = "V";
		String strWeight = "";
		if(m_comboWeight.getItemCount()>0)
			strWeight = m_comboWeight.getSelectedItem().toString();
		
		if(m_btnFemale.isSelected()){
			strGender = "M";
		}
		//m_fieldSelectedParameters.setText(m_tblNutrition.getDataString(strGender,strAge));
		Vector vect = m_tblNutrition.getDataVector(strGender,strAge,strWeight);
		String text = "";
		for(int i = 0; i < vect.size(); i++){
			Parameter param = (Parameter)vect.elementAt(i); 
			text += param.Name()+"=" + param.Value()+"\n";
		}
		m_fieldSelectedParameters.setText(text);
	}
	public Parameter getNormByName(String strName){
		String strAge = m_comboAge.getSelectedItem().toString();
		String strGender = "V";
		String strWeight = "";
		strWeight = m_comboWeight.getSelectedItem().toString();
		if(m_btnFemale.isSelected()){
			strGender = "M";
		}
		return m_tblNutrition.getNormByName(strGender,strAge,strName,strWeight);
	}
	public boolean dataReady(){
		if(m_tblNutrition.count()>0){
			return true;
		}
		return false;
	}
	public void fillWithFemaleWeight(){
		Vector vect = m_tblNutrition.getFemaleWeigthList();
		m_comboWeight.removeAllItems();
		for(int i = 0; i < vect.size(); i++){
			m_comboWeight.insertItemAt(vect.elementAt(i),i);
		}
	}
	public void fillWithMaleWeight(){
		Vector vect = m_tblNutrition.getMaleWeigthList();
		m_comboWeight.removeAllItems();
		for(int i = 0; i < vect.size(); i++){
			m_comboWeight.insertItemAt(vect.elementAt(i),i);
		}
	}
	public Vector getRestrictNames(){
		return m_tblNutrition.getRestrictNames();
	}
	public void setMain(MainApp m){
		m_main = m;
	}
}
