import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JDataPanel extends JPanel implements ActionListener, MouseListener{
	private ProductTable m_tblProducts;
	private JScrollPane m_panelScroll;
	private JPanel m_panelNewProduct;
	private JLabel m_labelProductName;
	private JTextField m_fieldProductName;
	private JButton m_btnAddProduct;
	private JPanel m_panelEnterData;
	private JPanel m_panelLoadFromFile;
	private JTextField m_fieldFilePath;
	private JButton m_btnLoad;
	private JLabel m_labelWarning;
	private JPopupMenu m_menuContext;
	private JMenuItem m_menuDelete;
	private JButton m_btnSave;
	private MainApp m_main;
	private String CodeBase;
	private JTextArea m_fieldText;
	private JScrollPane m_scrollXMLText;
	public JDataPanel(String strCodeBase){
		CodeBase = strCodeBase;
		m_tblProducts = new ProductTable();
		m_panelScroll = new JScrollPane(m_tblProducts);
		m_panelNewProduct = new JPanel();
		m_labelProductName = new JLabel("Produktas");
		m_fieldProductName = new JTextField();
		m_fieldProductName.setColumns(10);
		m_panelEnterData = new JPanel();
		m_panelLoadFromFile = new JPanel();
		m_btnAddProduct = new JButton("Itraukti");
		m_fieldFilePath = new JTextField(CodeBase);
		m_fieldFilePath.setColumns(20);
		m_btnLoad = new JButton("Pasirinkti faila");
		m_labelWarning = new JLabel("");
		m_menuContext = new JPopupMenu();
		m_menuDelete = new JMenuItem("Pasalinti");
		m_menuContext.add(m_menuDelete);
		
		m_fieldText = new JTextArea();
		m_fieldText.setRows(10);
		m_scrollXMLText = new JScrollPane(m_fieldText);
		
		m_btnSave = new JButton("Rodyti XML Formatu");
		
		super.setLayout(new BorderLayout());
		super.add(m_panelScroll,BorderLayout.CENTER);
		super.add(m_panelEnterData,BorderLayout.NORTH);
		super.add(m_scrollXMLText, BorderLayout.SOUTH);
		m_panelEnterData.setLayout(new BorderLayout());
		m_panelEnterData.add(m_panelNewProduct,BorderLayout.WEST);
		m_panelEnterData.add(m_panelLoadFromFile,BorderLayout.EAST);
		m_panelEnterData.add(m_labelWarning,BorderLayout.SOUTH);
		m_panelEnterData.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Duomenu ivedimas"),BorderFactory.createEmptyBorder(1,1,1,1)));	
		m_panelNewProduct.add(m_labelProductName);
		m_panelNewProduct.add(m_fieldProductName);
		m_panelNewProduct.add(m_btnAddProduct);
		m_panelNewProduct.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Po viena"),BorderFactory.createEmptyBorder(1,1,1,1)));
		m_panelLoadFromFile.add(m_fieldFilePath);
		m_panelLoadFromFile.add(m_btnLoad);
		m_panelLoadFromFile.add(m_btnSave);
		m_panelLoadFromFile.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Is failo"),BorderFactory.createEmptyBorder(1,1,1,1)));
		
		
		m_tblProducts.addMouseListener(this);
		
		m_btnAddProduct.addActionListener(this);
		m_btnLoad.addActionListener(this);
		m_menuDelete.addActionListener(this);
		m_btnSave.addActionListener(this);
		m_btnSave.setEnabled(false);
	}
	public void actionPerformed(ActionEvent event) {
		if(event.getActionCommand().equals("Itraukti")){
			if(!m_fieldProductName.getText().trim().equals("")){
				m_tblProducts.addRow(m_fieldProductName.getText());
				m_fieldProductName.setText("");
				m_labelWarning.setText("Produktas idetas sekmingai");
				if(m_tblProducts.count()>0){
					m_btnSave.setEnabled(true);
				}
				else
					m_btnSave.setEnabled(false);
			}
			else
			{
				m_labelWarning.setText("Nurodykite produkto pavadinima");
			}
		}
		else if(event.getActionCommand().equals("Pasirinkti faila")){
			m_labelWarning.setText("");
			try {
					m_tblProducts.flushTable();
					//commented for applet
					//chooser.setCurrentDirectory(new File(CodeBase));
					//XMLFileFilter filter = new XMLFileFilter();
					//chooser.setFileFilter(filter);
					//int returnVal = chooser.showOpenDialog(this);
				    //if(returnVal == JFileChooser.APPROVE_OPTION) {
					// not in browser, use chooser.getSelectedFile().getName();	
			    	URL fileURL = new URL(m_fieldFilePath.getText());
			    	InputStream in = fileURL.openStream();
			    	if(loadXML(in)){
			    		m_labelWarning.setText("Duomenys uzkrauti sekmingai");
			    	}
					in.close();
				    //}
						
				}
				catch(MalformedURLException e){
					m_labelWarning.setText("Blogas duomenu failo vardas");
				}
				catch (IOException e) {
					m_labelWarning.setText("Klaida nuskaitant duomenis");
					e.printStackTrace();
				}
				if(m_tblProducts.count()>0){
					m_btnSave.setEnabled(true);
					m_main.enable(1);
					if(m_main.parameterDataReady()){
						m_main.enable(2);
					}
				}
				else{
					m_btnSave.setEnabled(false);
					m_main.disable(1);
					m_main.disable(2);
				}
			}
		
		else if(event.getActionCommand().equals("Pasalinti")){
			m_tblProducts.removeRow(m_tblProducts.getSelectedRow());
			m_labelWarning.setText("produktas sekmingai pasalintas");
			if(m_tblProducts.count()>0){
				m_btnSave.setEnabled(true);
				m_main.enable(1);
				if(m_main.parameterDataReady()){
					m_main.enable(2);
				}
			}
			else{
				m_btnSave.setEnabled(false);
				m_main.disable(1);
				m_main.disable(2);
			}
		}
		else if(event.getActionCommand().equals("Rodyti XML Formatu")){
			//JFileChooser chooser = new JFileChooser();
				//chooser.setCurrentDirectory(new File(new File(".").getCanonicalPath()).getParentFile());
				//XMLFileFilter filter = new XMLFileFilter();
				//chooser.setFileFilter(filter);
				//int returnVal = chooser.showOpenDialog(this);
			   // if(returnVal == JFileChooser.APPROVE_OPTION) {	
			
					m_tblProducts.saveToFile(m_fieldText);
			    	//m_tblProducts.saveToFile(chooser.getCurrentDirectory()
					//		+ "\\" + chooser.getSelectedFile().getName());
			    //}	
		}
		else {
			m_labelWarning.setText("");
		}
	}
	public boolean loadXML(InputStream stream){
		InputSource source = new InputSource(stream);
	      try {
	    	XMLReader parser = XMLReaderFactory.createXMLReader();
	    	DataExtractor handler = new DataExtractor();
	    	
	    	parser.setContentHandler(handler);
	    	handler.addDataListener(m_tblProducts);
			parser.parse(source);
			handler.removeDataListener(m_tblProducts);
		} catch (SAXException e) {
			System.out.println("document is not well-formed");		
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	public String getValue(int p_iProductID, String p_strValueName){
		return m_tblProducts.getData(p_iProductID, p_strValueName);
	}
	public int getProductCount(){
		return m_tblProducts.getProductCount();
	}
	public int getRestrictionCount(){
		return m_tblProducts.getRestrictionCount();
	}
	public Vector getRestrictNames(){
		return m_tblProducts.getRestrictNames();
	}
	private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
	        m_menuContext.show(e.getComponent(),e.getX(), e.getY());
        }
    }
	public void mouseClicked(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	public void mousePressed(MouseEvent e) {
		if(m_tblProducts.getSelectedRow()!=-1){
			maybeShowPopup(e);
		}
	}
	public void mouseReleased(MouseEvent e) {
		if(m_tblProducts.getSelectedRow()!=-1){
			maybeShowPopup(e);
		}
	}
	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	public String getValueByColumnName(int row,String strName){
		return m_tblProducts.getValueByColumnName(row, strName);
	}
	public boolean dataReady(){
		if(m_tblProducts.count()>0){
			return true;
		}
		return false;
	}
	public void setMain(MainApp m){
		m_main = m;
	}
}
