import java.util.Vector;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DataExtractor extends DefaultHandler{
	private DataListener listener;
	private String data = "";
	private String prevData = "";
	private String prevQualifiedName = "";
	private Vector columns;
	private boolean bFirstRun = true;
	public DataExtractor(){
		columns = new Vector();
	}
	public void characters(char[] text, int start, int length)
	   throws SAXException {
		prevData = data;
		data = formString(text,start,length);
		//System.out.println(data);
	  }
	public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts){
		if(!columns.contains(qualifiedName.toUpperCase())){
			columns.addElement(qualifiedName.toUpperCase());
		}
		if(prevData.trim().equals("")&& data.trim().equals("") && qualifiedName.toUpperCase().equals(prevQualifiedName.toUpperCase()) || bFirstRun==true){
			bFirstRun = false;
			setNewRow();
		}
		prevQualifiedName = qualifiedName.toUpperCase();
	}
	public void endElement(String namespaceURI, String localName, String qualifiedName) {
		if(!columns.contains(qualifiedName.toUpperCase())){
			columns.addElement(qualifiedName);		
		}
		else{
			if(!data.trim().equals("")){
				setNewColumn(qualifiedName.toUpperCase());
				
				setData(qualifiedName,data);
				//System.out.println(qualifiedName);
				//System.out.println(data);
			}
		}
		prevQualifiedName = qualifiedName.toUpperCase();
	}
	private String formString(char[] text, int start, int length){
		StringBuffer sb = new StringBuffer();
		for(int i = start; i < start+length; i++){
			sb.append(text[i]);
		}
		return sb.toString();
	}
	public void addDataListener(DataListener listener) {
		this.listener = listener;
	}
	public void removeDataListener(DataListener listener) {
		this.listener = null;
	}
	public void setNewColumn(String strColumnName){
		if(listener!=null){
			listener.getNewColumn(strColumnName);
		}
	}
	public void setData(String strColumnName, String strValue){
		if(listener!=null){
			listener.getData(strColumnName,strValue);
		}
	}
	public void setNewRow(){
		if(listener!=null){
			listener.getNewRow();
		}
	}
}