import java.awt.*;
import java.lang.*;
import java.lang.Math;

public class GraphCanvas extends Canvas {

   public static final int startMinX = 20;
   public static final int startMinY = 20;

   public boolean doCalc = false;

   public int xSize;	// x ilgis
   public int ySize;	// y ilgis
   
   private int startGrX = 50;
   private int startGrY = 50;
   private int endGrX = 350;
   private int endGrY = 330;
   
   private int yMargin = 10;
   private int xMargin = 20;
   
   //private int halfX = 280;
   //private int halfY = 120;
   
   public Calculations data = new Calculations();
   
   private String caption;
   
   public GraphCanvas() {
   	setTitle("");
        this.setBackground(Color.lightGray);
    	repaint();
   }
   
   public GraphCanvas(int xSize, int ySize) {

   	this.xSize = xSize;
   	this.ySize = ySize;
   	setTitle("");
   	this.setBackground(Color.lightGray);
    	repaint();

   }
   
   public void paint(Graphics g) {

	Font titlesFont = new Font("ArialNarrow", Font.PLAIN, 12);
	g.setFont(titlesFont);
	g.setColor(Color.black);
	g.drawString(caption, 10, 9);
	
	g.setColor(Color.white);
	g.drawLine(5, 5, 8, 5);
	g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(caption), 5, getSize().width - 6, 5);
	g.drawLine(5, 5, 5, getSize().height - 6);
	g.drawLine(getSize().width - 5, 5, getSize().width - 5, getSize().height - 6);
	g.drawLine(getSize().width - 5, getSize().height - 5, 5, getSize().height - 5);
	
	g.setColor(Color.gray);		
	g.drawLine(4, 4, 8, 4);
	g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(caption), 4, getSize().width - 5, 4);
	g.drawLine(4, 4, 4, getSize().height - 5);
	g.drawLine(getSize().width - 6, 6, getSize().width - 6, getSize().height - 7);
	g.drawLine(getSize().width - 7, getSize().height - 6, 6, getSize().height - 6);
	
	g.setColor(Color.black);
        g.drawRect(startMinX - 2, startMinY - 2, xSize - 2*startMinX + 4, ySize - 2*startMinY + 4);
        g.setColor(Color.white);
        g.fillRect(startMinX - 1, startMinY - 1, xSize - 2*startMinX + 3, ySize - 2*startMinY + 3);

// koordinachiu  ashys ir uzhrashai
        g.setFont(new Font("Helvetica", Font.BOLD, 10));        
        g.setColor(Color.black);
        g.drawLine(startGrX, startGrY, startGrX, endGrY);
        g.drawLine(startGrX, (endGrY - startGrY)/2 + startGrY , endGrX, (endGrY - startGrY)/2 + startGrY);
        
        g.drawLine(startGrX - 2, startGrY + yMargin, startGrX + 2, startGrY + yMargin);
        g.drawString(String.valueOf(3 * (data.sig + data.sig0)), 30, startGrY);
        g.drawLine(startGrX - 2, endGrY - yMargin, startGrX + 2, endGrY - yMargin);
        g.drawString(String.valueOf(-3 * (data.sig + data.sig0)), 30, endGrY + 10);
        
        g.drawLine(endGrX - xMargin, (endGrY - startGrY)/2 + startGrY - 2, endGrX - xMargin, (endGrY - startGrY)/2 + startGrY + 2);
        g.drawString("" + data.N, endGrX - xMargin - 4, (endGrY - startGrY)/2 + startGrY + 15);
 	g.drawString("0", 35, 194);

	int xCoeff = ((endGrX - startGrX - xMargin) / data.N);
	int yCoeff = (endGrY - startGrY)/2 - yMargin;
        
// grafikas
	g.setColor(Color.black);
      	for (int i = 1; i < data.N; i++) {
        	g.drawOval(i * xCoeff  + startGrX, yCoeff - (int)(data.krt[i] * yCoeff / data.M), 2, 2);
    	}  
    	
// melyni taskai
	g.setColor(Color.blue);
        
        for (int i = 1; i < data.N; i++) {
        	g.drawOval(i * xCoeff + startGrX, yCoeff - (int)(data.w[i] * yCoeff / data.M),
        	2, 2);
    	}
    	
// raudoni taskai    	
    	g.setColor(Color.red);
      	for (int i = 1; i < data.N; i++){
        	g.drawOval(i * xCoeff  + startGrX, yCoeff - (int)(data.s[i] * yCoeff / data.M), 2, 2);
    	}
    	
// pasirinktas butas
	g.setColor(Color.green); 
        g.drawOval(data.p * xCoeff  + startGrX, yCoeff - (int)(data.s[data.p] * yCoeff / data.M), 2, 2);
        g.drawOval(data.g * xCoeff  + startGrX, yCoeff - (int)(data.s[data.g] * yCoeff / data.M), 2, 2);
        	
// linijos jungiancios
      	g.setColor(Color.black);
      	for (int i = 1; i < data.N; i++) {
      		g.drawLine((i-1) * xCoeff  + startGrX, yCoeff - (int)(data.krt[i-1] * yCoeff / data.M),
      			i * xCoeff  + startGrX, yCoeff - (int)(data.krt[i] * yCoeff / data.M));
      				
      	}  
      
/*      g.setColor(Color.pink);
      for (int i = 0; i < data.N; i++)
    	{
         g.drawLine(i * (400 / data.N) + 50, 200 - (int)(data.s[i] * (200.0 / data.M)), i * (400 / data.N) + 50, 200 - (int)(data.w[i] * (200.0 / data.M)));
    	}	
	*/
        
        
  }

/** Changes title of the map 
  * @param name - title.
  * @return No return value
*/
     public void setTitle(String name) {
   	caption = name;
   	repaint();
     }
     
} 
