/*
    Multiple bride problem solution program
    Written by Robertas Damasevicius, KTU
    May, 2000

*/

import java.awt.*;
import java.util.*;
import java.io.*;
import java.applet.*;

//Si klase atsakinga uz pagrindini programos langa
final class Nuot extends Frame {

    //patikrinimas ar visos ivestos reiksmes tenkina intervalus
    boolean check_parms()
    {
        grooms = (new Integer(n_groom.getText())).intValue();
        d_groom = (new Double(d_gr_good.getText())).doubleValue();
        d_bride = (new Double(d_b_imp.getText())).doubleValue();
	waiting = (new Double(waitfield.getText())).doubleValue();
	divorce = (new Double(divfield.getText())).doubleValue();

        if(grooms<10) {
            new MessageBox(this,"Number of grooms must be greater than 10.");
            return false;
        }
        else if(grooms>100) {
            new MessageBox(this, "Number of grooms must be lower than 100.");
            return false;
        }
        else if(d_bride<d_groom/30.0) {
            new MessageBox(this, "Distr. of bride's impression must be greater than "+d_groom/30.0);
            return false;
        }
        else if(d_bride>d_groom) {
            new MessageBox(this, "Distr of bride's impression must be lower than "+d_groom);
            return false;
        }
 	else if(waiting>(d_bride+d_groom)) {
            new MessageBox(this, "Waiting cost must be lower than "+(d_bride+d_groom));
            return false;
        }
	else if(waiting<0) {
            new MessageBox(this, "Waiting cost must be higher than 0");
            return false;
        }
 	else if(divorce>(d_bride+d_groom)) {
            new MessageBox(this, "Divorce cost must be lower than "+(d_bride+d_groom));
            return false;
        }
	else if(divorce<0) {
            new MessageBox(this, "Divorce cost must be higher than 0");
            return false;
        }
        else return true;
    }

    //kintamieji
    MessageBox newMsg;
    int grooms = 0;
    double d_bride = 0.0;
    double d_groom = 0.0;
    double waiting = 0.0;
    double divorce = 0.0;
    Calc n_data = new Calc();
    Graph graphic = null;
    MarrInfo m_i = null;
    int best_groom, marr_groom;

    //pagal reiksme is ComboBox, grazina spalvos reiksme
    Color showColor(int index) {
        if(index == 0)  return Color.black;
        if(index == 1)  return Color.blue;
        if(index == 2)  return Color.cyan;
        if(index == 3)  return Color.darkGray;
        if(index == 4)  return Color.gray;
        if(index == 5)  return Color.green;
        if(index == 6)  return Color.lightGray;
        if(index == 7)  return Color.magenta;
        if(index == 8)  return Color.orange;
        if(index == 9)  return Color.pink;
        if(index == 10) return Color.red;
        if(index == 11) return Color.white;
        if(index == 12) return Color.yellow;
        return Color.black;
    }

    //konstruktorius
    public Nuot() {

    	super("Multiple brides problem solution window");
	rec=0;
       	MenuBar mb = new MenuBar();
    	helpMenu = new Menu("Help");
    	helpMenu.add(new MenuItem("About..."));
    	mb.add(helpMenu);
    	setMenuBar(mb);

    	setLayout(null);
    	addNotify();

    	resize(insets().left + insets().right + 640, insets().top + insets().bottom + 343);

    	label1=new Label("Number of grooms", Label.RIGHT);
    	add(label1);
    	label1.reshape(insets().left + 14,insets().top + 7,245,19);
    	n_groom=new TextField("50",13);
    	add(n_groom);
    	n_groom.reshape(insets().left + 280,insets().top + 3,112,27);

    	label2=new Label("Distribution of groom's goodness", Label.RIGHT);
    	add(label2);
    	label2.reshape(insets().left + 14,insets().top + 34,245,19);
    	d_gr_good=new TextField("0.25",13);
    	add(d_gr_good);
    	d_gr_good.reshape(insets().left + 280,insets().top + 30,112,27);

    	label3=new Label("Distribution of bride's impression", Label.RIGHT);
    	add(label3);
    	label3.reshape(insets().left + 14,insets().top + 61,245,19);
    	d_b_imp=new TextField("0.1",13);
    	add(d_b_imp);
    	d_b_imp.reshape(insets().left + 280,insets().top + 57,112,27);

    	label4=new Label("Waiting cost", Label.RIGHT);
    	add(label4);
    	label4.reshape(insets().left + 14,insets().top + 88,245,19);
    	waitfield=new TextField("0",13);
    	add(waitfield);
    	waitfield.reshape(insets().left + 280,insets().top + 84,112,27);

    	label5=new Label("Divorce cost", Label.RIGHT);
    	add(label5);
    	label5.reshape(insets().left + 14,insets().top + 115,245,19);
    	divfield=new TextField("0",13);
    	add(divfield);
    	divfield.reshape(insets().left + 280,insets().top + 111,112,27);

 	check_which=new CheckboxGroup();
	Panel p=new Panel();
    	p.add(new Checkbox("Multiple bride",check_which,true));
   	p.reshape(insets().left + 495,insets().top + 5,112,27);
	add(p);
	p=new Panel();
    	p.add(new Checkbox("Single bride  ",check_which,false));
   	p.reshape(insets().left + 495,insets().top + 25,112,27);
	add(p);

    	rec_button=new Button("Calculate");
    	add(rec_button);
    	rec_button.reshape(insets().left + 455,insets().top + 67,161,26);

    	update_button=new Button("Update graph");
    	add(update_button);
    	update_button.reshape(insets().left + 455,insets().top + 97,161,26);
	update_button.hide();

	quit_button=new Button("Quit");
    	add(quit_button);
    	quit_button.reshape(insets().left + 455,insets().top + 127,161,26);

    	check_1=new Checkbox("Bride solutions");
    	add(check_1);
    	check_1.reshape(insets().left + 42,insets().top + 172,378,20);
    	check_1.setState(true);
    	check_2=new Checkbox("Goodness of grooms");
    	add(check_2);
    	check_2.reshape(insets().left + 42,insets().top + 201,378,20);
    	check_3=new Checkbox("Bride impressions");
    	add(check_3);
    	check_3.reshape(insets().left + 42,insets().top + 230,378,20);
   	check_3.setState(true);
    	check_4=new Checkbox("Draw line between bride solution points");
    	add(check_4);
    	check_4.reshape(insets().left + 42,insets().top + 259,378,20);
    	check_4.setState(true);
    	check_5=new Checkbox("Draw line between bride impression AND groom goodness");
    	add(check_5);
    	check_5.reshape(insets().left + 42,insets().top + 288,378,20);
   	check_6=new Checkbox("Draw only one multiple bride solution curve");
    	add(check_6);
    	check_6.reshape(insets().left + 42,insets().top + 317,378,20);
    	check_6.setState(true);
    	
    	choice1= new Choice();
    	add(choice1);
    	choice1.reshape(insets().left + 455,insets().top + 156,154,65);
        createChoice(choice1);
        choice1.select(1);
    	choice2= new Choice();
    	add(choice2);
    	choice2.reshape(insets().left + 455,insets().top + 184,154,65);
    	createChoice(choice2);
    	choice2.select(8);
    	choice3= new Choice();
    	add(choice3);
    	choice3.reshape(insets().left + 455,insets().top + 212,154,65);
    	createChoice(choice3);
    	choice3.select(10);
    	choice4= new Choice();
    	add(choice4);
    	choice4.reshape(insets().left + 455,insets().top + 240,154,65);
    	createChoice(choice4);
    	choice4.select(0);
    	choice5= new Choice();
    	add(choice5);
    	choice5.reshape(insets().left + 455,insets().top + 268,154,65);
    	createChoice(choice5);
    	choice5.select(12);
    	//}}
	setResizable(false);
    	show();
    }

    //sukuriamas spalvu pasirinkimas
    void createChoice( Choice ch) {
    	ch.addItem("black");
    	ch.addItem("blue");
    	ch.addItem("cyan");
    	ch.addItem("darkgray");
    	ch.addItem("gray");
    	ch.addItem("green");
    	ch.addItem("lightgray");
    	ch.addItem("magenta");
    	ch.addItem("orange");
    	ch.addItem("pink");
    	ch.addItem("red");
    	ch.addItem("white");
    	ch.addItem("yellow");
    }

    public synchronized void show() {
    	move(50, 50);
    	super.show();
    }

    //ivykiu valdymas
    public boolean handleEvent(Event event) {
	if (event.id == Event.ACTION_EVENT && event.target == rec_button) {
		clickedRecButton();
		return true;
	}
	else
	if (event.id == Event.ACTION_EVENT && event.target == update_button) {
		clickedUpdateButton();
		return true;
	}
	else
	if (event.id == Event.ACTION_EVENT && event.target == quit_button){
	    	handleEvent(new Event(this, Event.WINDOW_DESTROY, null));
	}
	else
	if (event.id == Event.WINDOW_DESTROY) {
	    if(graphic != null) graphic.hide();
	    if(m_i != null) m_i.hide();
	    hide();         // hide the Frame
	    dispose();      // tell windowing system to free resources
	    System.exit(0); // exit
	    return true;
	}
	return super.handleEvent(event);
    }

    //pasirinkimas is meniu
    public boolean action(Event event, Object arg) {
	if (event.target instanceof MenuItem) {
	    String label = (String) arg;
	    if (label.equalsIgnoreCase("About...")) {
		new AboutBox(this);
		return true;
	    }
	}
	return super.action(event, arg);
    }

    public static void main(String args[]) {
	new Nuot();
    }

    Menu helpMenu;
    Label label1;
    TextField n_groom;
    Label label2;
    Label label3;
    Label label4;
    Label label5;
    TextField waitfield;
    TextField divfield;
    TextField d_gr_good;
    TextField d_b_imp;
    Button rec_button;
    Button update_button;
    int rec;
    Checkbox check_1;
    Checkbox check_2;
    Checkbox check_3;
    Checkbox check_4;
    Checkbox check_5;
    Checkbox check_6;
    CheckboxGroup check_which;
    int which;
    Button quit_button;
    Choice choice1;
    Choice choice2;
    Choice choice3;
    Choice choice4;
    Choice choice5;

    //iskvieciamas nuspaudus 'ReCalculate' mygtuka
    //atlieka visus perskaiciavimus pagal pateiktus duomenis
    public void clickedRecButton() {
	
	if (check_which.getCurrent().getLabel().equals("Multiple bride")) which=1;
	else which=0;

        if(check_parms()) {
            n_data.init(grooms, d_bride, d_groom,waiting,divorce,which);
	    if (m_i!=null) m_i.hide();
    	    if (graphic!=null) graphic.hide();
            m_i=n_data.reCalc_bride(d_bride,d_groom);
	    if (which==1)
            	graphic = new Graph((Math.floor(((d_bride+d_groom)*3+divorce)*10))/10,grooms,"Number of grooms: "+grooms+
              	  "; bride distribution: "+d_bride+"; grooms distribution: "+d_groom);
		else
		graphic = new Graph((Math.floor((d_bride+d_groom)*3*10))/10,grooms,"Number of grooms: "+grooms+
              	  "; bride distribution: "+d_bride+"; grooms distribution: "+d_groom);
            m_i.show();
            m_i.repaint();

	    clickedUpdateButton();
	    update_button.show();

	    rec=1;
        }
    }

	// atliekamas duomenu (jaunikiu gerumu ir nuotakos ispudziu) irasymas i faila
	void writeData(String datafile,int n,double coef1[],double coef2[],double coef3[], int mul)
	{
	try
	{
	String tmp;
	File file=new File(datafile);
	FileWriter fw = new FileWriter(file);
	BufferedWriter bw=new BufferedWriter(fw);

	String head=new String("Groom         Goodness                    Impression                   Critical           Marriage");	
	bw.write(head,0,head.length());
	bw.newLine();
	bw.newLine();
	double max=0;
	int checked=0;
	for (int i=0;i<n;i++)
	{
		tmp=(new Integer(i)).toString();
		tmp+=new String("       ");
		bw.write(tmp,0,tmp.length());

		tmp=(new Double(coef1[i])).toString();
		bw.write(tmp,0,tmp.length());

		tmp=new String("         ");
		bw.write(tmp,0,tmp.length());

		tmp=(new Double(coef2[i])).toString();
		bw.write(tmp,0,tmp.length());

		tmp=new String("         ");
		bw.write(tmp,0,tmp.length());

		tmp=(new Double(coef3[i])).toString();
		bw.write(tmp,0,tmp.length());

		if ((mul==1)||(checked==0))
		if ((coef2[i]>=coef3[i])&&(max+divorce<=coef2[i])){
		checked=1;
		max=coef2[i];
		tmp=new String("           *");
		bw.write(tmp,0,tmp.length());
		}
		bw.newLine();
	}
	bw.close();
	fw.close();

	}
	catch (IOException ioex)
	{
	System.out.println("Error while writing data to file.");
	}
	}

    //iskvieciamas nuspaudus 'Update graph' mygtuka
    //perduoda visus apskaiciuotus ir nurodytus duomenis atvaizdavimui
    public void clickedUpdateButton() {
        double temp[] = new double[grooms];
        double temp2[][] = new double[grooms][grooms];
	int n;
        if(check_parms()) {
            n=n_data.copy_all_bride_arrays(temp2);
            graphic.setAllBrideData(temp2,n);
            n_data.copy_bride_array(temp);
            graphic.setBrideData(temp);
            n_data.copy_groom_array(temp);
            graphic.setGroomData(temp);
            n_data.copy_bride_impr_array(temp);
            graphic.setBrideImpr(temp);
            graphic.setShowData(1,check_1.getState(), showColor(choice1.getSelectedIndex()));
            graphic.setShowData(2,check_2.getState(), showColor(choice2.getSelectedIndex()));
            graphic.setShowData(3,check_3.getState(), showColor(choice3.getSelectedIndex()));
            graphic.setShowData(4,check_4.getState(), showColor(choice4.getSelectedIndex()));
            graphic.setShowData(5,check_5.getState(), showColor(choice5.getSelectedIndex()));
            graphic.setShowData(6,check_6.getState());
            graphic.show();
            graphic.repaint();
        }
    }
}
