import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.*;
import javax.swing.table.*;

public class TrendEditDialog extends JDialog
{
	JPanel jpMain = new JPanel();
	BorderLayout borderLayout1 = new BorderLayout();
	JPanel jpButtons = new JPanel();
	JButton jbOk = new JButton();
	JScrollPane jspTrends = new JScrollPane();
	JTable jtTrends = new JTable();

	protected Trend editedTrend;

	public TrendEditDialog(Frame frame, Trend trend)
	{
		super(frame, "Edit trend values", true);

		editedTrend = trend;
		try
		{
			jbInit();
			pack();
			setResizable(false);
			setLocationRelativeTo(frame);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}

	protected TrendEditDialog()
	{
		this(null, null);
	}

	public void changeValues()
	{
		setVisible(true);
	}

	void jbInit() throws Exception
	{
		jpMain.setLayout(borderLayout1);
		jbOk.setMnemonic('O');
		jbOk.setText("Ok");
		jbOk.addActionListener(new java.awt.event.ActionListener()
		{

			public void actionPerformed(ActionEvent e)
			{
				jbOk_actionPerformed(e);
			}
		});
		getContentPane().add(jpMain);
		jpMain.add(jpButtons, BorderLayout.SOUTH);
		jpButtons.add(jbOk, null);
		jpMain.add(jspTrends, BorderLayout.CENTER);
		jtTrends.setModel(new TrendTableModel(editedTrend));
		jspTrends.getViewport().add(jtTrends, null);
	}

	void jbOk_actionPerformed(ActionEvent e)
	{
		//read the values from table
		setVisible(false);
	}

	protected class TrendTableModel extends AbstractTableModel
	{
		protected Trend trend;
		protected Vector specTrends;

		public TrendTableModel(Trend trend)
		{
			this.trend = trend;
			specTrends = this.trend.getSpecifiedTrends();
		}

		public int getRowCount()
		{
			return specTrends.size();
		}

		public int getColumnCount()
		{
			return 2;
		}

		public Object getValueAt(int rowIndex, int columnIndex)
		{
			if (columnIndex == 0)
				return specTrends.elementAt(rowIndex);
			else if (columnIndex == 1)
				return trend.getSpecifiedTrendValue(rowIndex);

			return null;
		}

		public String getColumnName(int column)
		{
			if (column == 0)
				return "Trend Name";
			else if (column == 1)
				return "Value";

			return "";
		}

		public boolean isCellEditable(int rowIndex, int columnIndex)
		{
			if (columnIndex == 0)
				return false;
			else if (columnIndex == 1)
				return true;

			return true;
		}

		public void setValueAt(Object aValue, int rowIndex, int columnIndex)
		{
			try
			{
				double newValue = Double.valueOf((String)aValue).doubleValue();
				trend.changeSpecifiedTrendValue(rowIndex, newValue);
			}
			catch (NumberFormatException _ex)
			{
				JOptionPane.showMessageDialog(TrendEditDialog.this, "Trend value has to be a floating point number",
											  "Error", JOptionPane.ERROR_MESSAGE);
			}
		}
	}
}