
import java.util.Vector;

public class Trend
{
	protected String name;

	protected Vector specifiedTrends = new Vector();
	protected Vector trendValues = new Vector();

	public Trend(String name)
	{
		this.name = name;
	}

	public void add(String specTrend)
	{
		specifiedTrends.add(specTrend);
		trendValues.add(new Double(0));
	}

	public Vector getSpecifiedTrends()
	{
		return specifiedTrends;
	}

	public Double getSpecifiedTrendValue(String trend)
	{
		int i = specifiedTrends.indexOf(trend);

		return this.getSpecifiedTrendValue(i);
	}

	public Double getSpecifiedTrendValue(int trendIndex)
	{
		Double value = (Double)trendValues.elementAt(trendIndex);

		return value;
	}

	public void changeSpecifiedTrendValue(String trend, double newValue)
	{
		int i = specifiedTrends.indexOf(trend);

		this.changeSpecifiedTrendValue(i, newValue);
	}

	public void changeSpecifiedTrendValue(int trendIndex, double newValue)
	{
		trendValues.set(trendIndex, new Double(newValue));
	}

	public String toString()
	{
		StringBuffer tmp = new StringBuffer();
		tmp.append(name);
		tmp.append(": ");

		for (int i = 0; i < specifiedTrends.size(); i++)
		{
			tmp.append(", ");
			String s = (String)specifiedTrends.elementAt(i);
			Double value = getSpecifiedTrendValue(s);
			tmp.append(s+'='+value+' ');
		}

		return tmp.toString();
	}
}