
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.border.*;

public class MainApplet extends JApplet
{
	boolean isStandalone = false;
	JPanel jpMain = new JPanel();
	BorderLayout borderLayout1 = new BorderLayout();
	JPanel jpData = new JPanel();
	JPanel jpResultsMain = new JPanel();
	BorderLayout borderLayout2 = new BorderLayout();
	JPanel jpCalculate = new JPanel();
	JPanel jpResults = new JPanel();
	JButton jbCalculate = new JButton();
	JTabbedPane jtpResults = new JTabbedPane();
	JScrollPane jspInformation = new JScrollPane();
	BorderLayout borderLayout3 = new BorderLayout();
	JList jlInformation = new JList();
	JPanel jpParametersMain = new JPanel();
	JPanel jpProblemMain = new JPanel();
	BorderLayout borderLayout4 = new BorderLayout();
	JPanel jpProblem = new JPanel();
	JLabel lProblem = new JLabel();
	JComboBox jcbProblem = new JComboBox();
	BorderLayout borderLayout5 = new BorderLayout();
	JPanel jpRecurence = new JPanel();
	JRadioButton jrbSingle = new JRadioButton();
	JRadioButton jrbMultiple = new JRadioButton();
	GridLayout gridLayout2 = new GridLayout();
	BorderLayout borderLayout6 = new BorderLayout();
	JPanel jpParameters = new JPanel();
	GridLayout gridLayout3 = new GridLayout();
	JPanel jpParametersLabels = new JPanel();
	JPanel jpParametersTexts = new JPanel();
	GridLayout gridLayout4 = new GridLayout();
	JLabel lGrooms = new JLabel();
	JLabel lBrideDispersion = new JLabel();
	GridLayout gridLayout5 = new GridLayout();
	JTextField jtfGrooms = new JTextField();
	JTextField jtfBrideDispersion = new JTextField();
	JLabel lGroomDispersion = new JLabel();
	JLabel lGrowth = new JLabel();
	JTextField jtfGroomDispersion = new JTextField();
	JTextField jtfGrowth = new JTextField();
	JLabel lWaitingCost = new JLabel();
	JLabel lDivorceCost = new JLabel();
	JTextField jtfWaitingCost = new JTextField();
	JTextField jtfDivorceCost = new JTextField();
	JScrollPane jspTrends = new JScrollPane();
	JList jlTrends = new JList();

	protected GraphCanvas resultGraph = new GraphCanvas();

	protected int grooms;
	protected double brideDisp;
	protected double groomDisp;
	protected double growth;
	protected double waitingCost;
	protected double divorceCost;

	private Trend[] activeTrendList = null;

	//Get a parameter value
	public String getParameter(String key, String def)
	{
		return isStandalone ? System.getProperty(key, def) :
				(getParameter(key) != null ? getParameter(key) : def);
	}

	//Construct the applet
	public MainApplet()
	{
	}

	//Initialize the applet
	public void init()
	{
		try
		{
			jbInit();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	//Component initialization
	private void jbInit() throws Exception
	{
		this.setSize(new Dimension(491, 434));
		jpMain.setLayout(borderLayout1);
		jpResultsMain.setLayout(borderLayout2);
		jbCalculate.setText("Calculate");
		jbCalculate.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jbCalculate_actionPerformed(e);
			}
		});
		jpData.setBorder(new TitledBorder("Data"));
		jpParametersMain.setLayout(borderLayout5);
		jpParameters.setBorder(new TitledBorder("Parameters"));
		jpRecurence.setBorder(new TitledBorder("Recurence"));
		jspTrends.setBorder(new TitledBorder("Trends"));
		jpRecurence.setLayout(gridLayout2);
		jpProblemMain.setLayout(borderLayout6);
		jpData.setLayout(borderLayout4);
		jpResults.setLayout(borderLayout3);
		lProblem.setText("Problem:");
		jrbSingle.setText("Single Bride");
		jrbMultiple.setText("Mutilple Bride");
		gridLayout2.setColumns(1);
		gridLayout2.setRows(2);
		jpParameters.setLayout(gridLayout3);
		gridLayout3.setColumns(2);
		gridLayout3.setHgap(5);
		jpParametersLabels.setLayout(gridLayout4);
		gridLayout4.setColumns(1);
		gridLayout4.setRows(6);
		gridLayout4.setVgap(5);
		lGrooms.setHorizontalAlignment(SwingConstants.RIGHT);
		lGrooms.setText("Number of Grooms:");
		lBrideDispersion.setHorizontalAlignment(SwingConstants.RIGHT);
		lBrideDispersion.setText("Bride Dispersion:");
		jpParametersTexts.setLayout(gridLayout5);
		gridLayout5.setColumns(1);
		gridLayout5.setRows(6);
		gridLayout5.setVgap(5);
		lGroomDispersion.setHorizontalAlignment(SwingConstants.RIGHT);
		lGroomDispersion.setText("Groom Dispersion:");
		lGrowth.setHorizontalAlignment(SwingConstants.RIGHT);
		lGrowth.setText("Goodness Growth:");
		lWaitingCost.setHorizontalAlignment(SwingConstants.RIGHT);
		lWaitingCost.setText("Waiting Cost:");
		lDivorceCost.setHorizontalAlignment(SwingConstants.RIGHT);
		lDivorceCost.setText("Divorce Cost:");
		jcbProblem.addItemListener(new java.awt.event.ItemListener()
		{

			public void itemStateChanged(ItemEvent e)
			{
				jcbProblem_itemStateChanged(e);
			}
		});
		jlTrends.addMouseListener(new java.awt.event.MouseAdapter()
		{

			public void mouseClicked(MouseEvent e)
			{
				jlTrends_mouseClicked(e);
			}
		});
		this.getContentPane().add(jpMain, BorderLayout.CENTER);
		jpMain.add(jpData, BorderLayout.WEST);
		jpData.add(jpProblemMain, BorderLayout.NORTH);
		jpProblemMain.add(jpProblem, BorderLayout.NORTH);
		jpProblem.add(lProblem, null);
		jpProblem.add(jcbProblem, null);
		jpProblemMain.add(jpRecurence, BorderLayout.CENTER);
		jpRecurence.add(jrbSingle, null);
		jpRecurence.add(jrbMultiple, null);
		jpData.add(jpParametersMain, BorderLayout.CENTER);
		jpParametersMain.add(jpParameters, BorderLayout.NORTH);
		jpParameters.add(jpParametersLabels, null);
		jpParametersLabels.add(lGrooms, null);
		jpParametersLabels.add(lBrideDispersion, null);
		jpParametersLabels.add(lGroomDispersion, null);
		jpParametersLabels.add(lGrowth, null);
		jpParametersLabels.add(lWaitingCost, null);
		jpParametersLabels.add(lDivorceCost, null);
		jpParameters.add(jpParametersTexts, null);
		jpParametersTexts.add(jtfGrooms, null);
		jpParametersTexts.add(jtfBrideDispersion, null);
		jpParametersTexts.add(jtfGroomDispersion, null);
		jpParametersTexts.add(jtfGrowth, null);
		jpParametersTexts.add(jtfWaitingCost, null);
		jpParametersTexts.add(jtfDivorceCost, null);
		jpParametersMain.add(jspTrends, BorderLayout.CENTER);
		jspTrends.getViewport().add(jlTrends, null);
		jpMain.add(jpResultsMain, BorderLayout.CENTER);
		jpResultsMain.add(jpCalculate, BorderLayout.SOUTH);
		jpCalculate.add(jbCalculate, null);
		jpResultsMain.add(jpResults, BorderLayout.CENTER);
		jpResults.add(jtpResults, BorderLayout.CENTER);
		jtpResults.add(jspInformation, "Information");
		jtpResults.add(resultGraph, "Charts");
		jspInformation.getViewport().add(jlInformation, null);
		jlInformation.setModel(new DefaultListModel());
		jlTrends.setModel(new DefaultListModel());
		jlTrends.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		jtpResults.setEnabledAt(1, false);

		ButtonGroup recurence = new ButtonGroup();
		recurence.add(jrbSingle);
		recurence.add(jrbMultiple);

		//initial values
		jrbSingle.setSelected(true);
		jcbProblem.setModel(new DefaultComboBoxModel(this.getProblemList()));

		jtfGrooms.setDocument(new NumberDocument(NumberDocument.INT_FORMAT));
		jtfBrideDispersion.setDocument(new NumberDocument(NumberDocument.DOUBLE_FORMAT));
		jtfGroomDispersion.setDocument(new NumberDocument(NumberDocument.DOUBLE_FORMAT));
		jtfGrowth.setDocument(new NumberDocument(NumberDocument.DOUBLE_FORMAT));
		jtfWaitingCost.setDocument(new NumberDocument(NumberDocument.DOUBLE_FORMAT));
		jtfDivorceCost.setDocument(new NumberDocument(NumberDocument.DOUBLE_FORMAT));

		jtfGrooms.setText("10");
		jtfBrideDispersion.setText("0.1");
		jtfGroomDispersion.setText("0.25");
		jtfGrowth.setText("0");
		jtfWaitingCost.setText("0");
		jtfDivorceCost.setText("0");
	}

	protected String[] getProblemList()
	{
		String[] problems = {"Standart Bride", "Autos", "Workers", "Grooms"};

		return problems;
	}

	protected Trend[] getTrendList(String problem)
	{
		if (activeTrendList == null)
			activeTrendList = loadTrendList(problem);

		return activeTrendList;
	}

	protected Trend[] loadTrendList(String problem)
	{
        Trend[] trends = null;
		String[] problems = getProblemList();

		if (problem.equals(problems[0]))
		{
			trends = new Trend[0];
		}
		else if (problem.equals(problems[1]))
		{
			trends = new Trend[6];

			trends[0] = new Trend("Color");
			trends[0].add("Bright");
			trends[0].add("Dark");
			trends[0].add("Shiny");

			trends[1] = new Trend("Body");
			trends[1].add("Sedan");
			trends[1].add("Universal");
			trends[1].add("Cabriolet");
			trends[1].add("Chechbeck");

			trends[2] = new Trend("Fuel");
			trends[2].add("Petrol");
			trends[2].add("Gas");
			trends[2].add("Diesel");

			trends[3] = new Trend("Engine");
			trends[3].add("Up to 1.5L");
			trends[3].add("From 1.5L to 2.0L");
			trends[3].add("Above 2.0L");

			trends[4] = new Trend("Doors");
			trends[4].add("2");
			trends[4].add("2 - 1");
			trends[4].add("4");
			trends[4].add("4 - 1");

			trends[5] = new Trend("Price");
			trends[5].add("above 100000 Lt.");
			trends[5].add("50000 Lt. - 100000 Lt.");
			trends[5].add("20000 Lt. - 50000 Lt.");
			trends[5].add("up to 20000 Lt.");
		}
		else if (problem.equals(problems[2]))
		{
			trends = new Trend[6];

			trends[0] = new Trend("Interview");
			trends[0].add("Bad");
			trends[0].add("Normal");
			trends[0].add("Good");

			trends[1] = new Trend("CV");
			trends[1].add("Poor");
			trends[1].add("Not clear");
			trends[1].add("Normal");
			trends[1].add("Full");

			trends[2] = new Trend("Education");
			trends[2].add("Profesional");
			trends[2].add("Higher");
			trends[2].add("Highest");

			trends[3] = new Trend("Expierence");
			trends[3].add("No expierence");
			trends[3].add("< 2 years");
			trends[3].add("2-5 years");
			trends[3].add("> 5 years");

			trends[4] = new Trend("Languages");
			trends[4].add("1 language");
			trends[4].add("2 languages");
			trends[4].add("3 languages");

			trends[5] = new Trend("Salary");
			trends[5].add("> 2000 Lt.");
			trends[5].add("2000 Lt. - 1500 Lt.");
			trends[5].add("1500 Lt. - 1000 Lt.");
			trends[5].add("< 1000 Lt.");
		}
		else if (problem.equals(problems[3]))
		{
			trends = new Trend[6];

			trends[0] = new Trend("Eyes");
			trends[0].add("Brown");
			trends[0].add("Gray");
			trends[0].add("Green");
			trends[0].add("Blue");

			trends[1] = new Trend("Height");
			trends[1].add("Low");
			trends[1].add("Normal");
			trends[1].add("High");

			trends[2] = new Trend("Hair Color");
			trends[2].add("Bright");
			trends[2].add("Gray");
			trends[2].add("Brown");
			trends[2].add("Dark");
			trends[2].add("Black");

			trends[3] = new Trend("Salary");
			trends[3].add("1000 Lt.");
			trends[3].add("2000 Lt.");
			trends[3].add("3000 Lt.");
			trends[3].add("4000 Lt.");

			trends[4] = new Trend("Drinks");
			trends[4].add("Inebriate");
			trends[4].add("Every week");
			trends[4].add("Sometimes");
			trends[4].add("Not drinking");

			trends[5] = new Trend("Weigth");
			trends[5].add("Above avarage");
			trends[5].add("Avarage");
			trends[5].add("Thin");
		}

		return trends;
	}

	//Start the applet
	public void start()
	{

	}

	//Stop the applet
	public void stop()
	{
	}

	//Destroy the applet
	public void destroy()
	{
	}

	//Get Applet information
	public String getAppletInfo()
	{
		return "Multiple bride algorith using trends";
	}

	//Get parameter info
	public String[][] getParameterInfo()
	{
		return null;
	}

	//Main method
	public static void main(String[] args)
	{
		MainApplet applet = new MainApplet();
		applet.isStandalone = true;
		JFrame frame = new JFrame();
		frame.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				System.exit(0);
			}
		});
		frame.setTitle("Applet Frame");
		frame.getContentPane().add(applet, BorderLayout.CENTER);
		applet.init();
		applet.start();
		frame.setSize(400, 320);
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
		frame.pack();
        frame.setVisible(true);

		applet.changeTrendList(applet.getProblemList()[0]);
	}

	private void jbCalculate_actionPerformed(ActionEvent e)
	{
		int multi = 0;
		if (jrbSingle.isSelected())
			multi = 0;
		else if (jrbMultiple.isSelected())
			multi = 1;

		if (this.checkData())
		{
			if ( jcbProblem.getSelectedItem().equals(this.getProblemList()[0]) )
			{
				resultGraph.sk_data.init(0, grooms, brideDisp, groomDisp, waitingCost, divorceCost, growth, multi);
				resultGraph.sk_data.reCalc_bride(brideDisp, groomDisp, 0);

				this.printResults();
				resultGraph.repaint();
			}
			else
				JOptionPane.showMessageDialog(this, "This feature is not implemented yet", "Information", JOptionPane.INFORMATION_MESSAGE);
		}

		jtpResults.setEnabledAt(1, true);
	}

	private void jcbProblem_itemStateChanged(ItemEvent e)
	{
		if (e.getStateChange() == ItemEvent.SELECTED)
		{
			activeTrendList = loadTrendList((String)e.getItem());
		    this.changeTrendList((String)e.getItem());
		}
	}

	private void jlTrends_mouseClicked(MouseEvent e)
	{
		int index = jlTrends.getSelectedIndex();

		if ((e.getClickCount() == 2) && (index != -1))
		{
			//JOptionPane.showMessageDialog(this, "Double click on list"+jlTrends.getSelectedIndex());
			Trend selectedTrend = this.getTrendList((String)jcbProblem.getSelectedItem())[index];
			TrendEditDialog edit = new TrendEditDialog(null, selectedTrend);
			edit.changeValues();
			this.changeTrendList((String)jcbProblem.getSelectedItem());
		}
	}


	private void changeTrendList(String problem)
	{
		DefaultListModel model = (DefaultListModel)jlTrends.getModel();
        model.clear();

		Trend[] trends = getTrendList(problem);
		for (int i = 0; i < trends.length; i++)
		{
			Trend trend = trends[i];
			model.addElement(trend);
		}
	}

	/**
	 * Prints out results of calculations
	 */
	private void printResults()
	{
		DefaultListModel results = (DefaultListModel)jlInformation.getModel();
		results.clear();

		results.addElement("Total grooms: " + grooms);
		results.addElement("Best is: " + resultGraph.sk_data.best_groom);
		results.addElement("His goodnes: " + resultGraph.sk_data.good_of_best);
		results.addElement("Impresion on him: " + resultGraph.sk_data.impr_of_best);
		results.addElement("Mariages: " + resultGraph.sk_data.num);
		for (int s = 0; s < resultGraph.sk_data.num; s++)
		{
			results.addElement("Groom: " + resultGraph.sk_data.marr_groom[s]);
			results.addElement("His goodnes: " + resultGraph.sk_data.marr_good[s]);
			results.addElement("Impresion on him: " + resultGraph.sk_data.marr_impr[s]);
		}
		;
	}

	/**
	 * Checks whether user entered correct data
	 */
	private boolean checkData()
	{
		grooms = Integer.valueOf(jtfGrooms.getText()).intValue();
		groomDisp = Double.valueOf(jtfGroomDispersion.getText()).doubleValue();
		brideDisp = Double.valueOf(jtfBrideDispersion.getText()).doubleValue();
		waitingCost = Double.valueOf(jtfWaitingCost.getText()).doubleValue();
		divorceCost = Double.valueOf(jtfDivorceCost.getText()).doubleValue();
		growth = Double.valueOf(jtfGrowth.getText()).doubleValue();

		boolean dataCorrect = true;

		DefaultListModel results = null;
		if (this.jlInformation.getModel() == null)
		{
			results = new DefaultListModel();
			jlInformation.setModel(results);
		}
		else
		{
			results = (DefaultListModel)jlInformation.getModel();
			results.clear();
		}

		if (grooms < 10)
		{
			results.addElement("Number of grooms must be greater than 10.");
			dataCorrect = false;
		}
		if (grooms > 100)
		{
			results.addElement("Number of grooms must be lower than 100.");
			dataCorrect = false;
		}
		if (brideDisp < groomDisp / 30.0)
		{
			results.addElement("Distr. of bride's impression must be greater than " + groomDisp / 30.0);
			dataCorrect = false;
		}
		if (brideDisp > groomDisp)
		{
			results.addElement("Distr. of bride's impression must be lower than " + groomDisp);
			dataCorrect = false;
		}
		if (waitingCost > (brideDisp + groomDisp))
		{
			results.addElement("Waiting cost must be lower than " + (brideDisp + groomDisp));
			dataCorrect = false;
		}
		if (waitingCost < 0)
		{
			results.addElement("Waiting cost must be higher than 0");
			dataCorrect = false;
		}
		if (divorceCost > (brideDisp + groomDisp))
		{
			results.addElement("Divorce cost must be lower than " + (brideDisp + groomDisp));
			dataCorrect = false;
		}
		if (divorceCost < 0)
		{
			results.addElement("Divorce cost must be higher than 0");
			dataCorrect = false;
		}
		if ((growth > 0.1) || (growth < -0.1))
		{
			results.addElement("Goodness growth must be lower then 0.1, or higher then -0.1 ");
			dataCorrect = false;
		}

		return dataCorrect;
	}

	public int getGrooms()
	{
		return grooms;
	}

	public double getBrideDisp()
	{
		return brideDisp;
	}

	public double getGroomDisp()
	{
		return groomDisp;
	}

	public double getGrowth()
	{
		return growth;
	}

	public double getWaitingCost()
	{
		return waitingCost;
	}

	public double getDivorceCost()
	{
		return divorceCost;
	}
}
