//NUOTAKOS PASITRINKIMU SKAICIAVIMAI
//remade by Marius Zemaitis

import java.awt.*;
import java.util.*;
import java.applet.*;

//Si klase atsakinga uz visus atliekamus skaiciavimus
//naudojasi funkcijomis is klases 'Gauss'
class Calc extends Gauss {

    double M_w = 1.0;       //maksimali galima w reiksme
    double M_s = 1.0;       //maksimali galima s reiksme
    
    double Sigma_w = 0.25;
    double Sigma_s = 0.05;
    
    double ps_s[];          //apskaiciuotas ps(s)
    double p_sw[][];        //apskaiciuotas p(s)*p(w)
    
    double impr[];          //Nuotakos ispudziai
    double [][]p_w_s;       //apskaiciuotas p(w|s)
    
    double jaun[];          //jaunikiu gerumai w
    
    double rel[][];         //Nuotakos pasirinkimu matrica
    double w[];             //kritiniai Nuotakos pasirinkimu taskai
    double all_w[][];
        
    
    // added by M.Z.
    int local_grooms;       //jaunikiu skaicius
    int best_groom;         //geriausias jaunikis
    double impr_of_best;    // ispudis apie ji
    double good_of_best;    // jo gerumas
    double []marr_impr=new double[100];
	double []marr_good=new double[100];
	int []marr_groom=new int[100];
	
	int []data=new int[100];
	double []randata = new double[100];
	double miu;         //senejimo procesas
    
    double waiting;		// laukimo kaina
    double divorce;		// skyrybu kaina;
    
	int multiple;

	int num=0;       // vedybu skaicius - M.Z. past


    //uzpildo reiksmes i masyvus:
    //  p_sw    - p(s)*p(w)
    //  ps_s    - ps(s)
    //  p_w_s   - p(w|s) = p(s)*p(w)/ps(s)
    void form_data(double []p_w) {
        int i, j;
        double sum, w, s;

        for(i=0;i<100;i++) {
            for(j=0;j<100;j++) {
                //
                w = (double)(2.0*M_w / 100.0*(double)j- M_w);
                s = (double)(2.0*M_s / 100.0*(double)i- M_s);
                //
                p_sw[i][j] = p_w[j]* probability(Sigma_s,s,w,2.0*M_s);
                // pagal Gauso pasiskirstyma ^
            }
        }

        for(i=0;i<100;i++){
            sum = 0.0;
            for(j=0;j<100;j++) {
                sum += p_sw[i][j];
            }
            ps_s[i] = sum;
        }

        for(i=0;i<100;i++) {
            for(j=0;j<100;j++) {
                p_w_s[i][j] = p_sw[j][i]/ps_s[j];
            }
        }

    }

    //suskaiciuoja Un reiksmes
    double Nth_sum(int i) {
        int j;
        double sum = 0.0;

        for(j=0;j<100;j++) {
            sum += (double)(2.0*M_w/100.0*(double)j-M_w)*p_w_s[j][i];
        }
        return sum;
    }

    //suskaiciuoja Un-1 reiksmes
    double Nth_1less_sum(int j) {
        double sum = 0.0;
        int i;

        for(i=0;i<101;i++) {
            sum += rel[j][i]*ps_s[i];
        }
        return sum;
    }

    //perskaiciuojami duomenys, susije su pirmu Nuotakos pasirinkimu
    double[] Calc_bride(double d_bride,double d_groom, double sns) {
	    double[] w=new double[100];
        double[] p_w = new double[100];
        int i, j;
        double tt;
        double sum;

        //suformuojamas p(w)
        for(i=0;i<100;i++) {
            p_w[i] = probability(Sigma_w,(double)(2.0*M_w/100.0*(double)i-M_w),sns,2.0*M_w);
        }
        form_data(p_w);

        for(i=0;i<100;i++) {
            rel[local_grooms-1][i] = Nth_sum(i);
        }
        w[local_grooms-1] = -M_s;

        //vyksta pasirinkimu formavimas
        for(j=local_grooms-2;j>=0;j--) {
            tt = Nth_1less_sum(j+1);
            for(i=0;i<100;i++) {
                rel[j][i] = Math.max(tt,rel[local_grooms-1][i]);
            }
            w[j] = Calc_max(j);     //kritiniai pasirinkimu taskai
        }
	return w;
	}

    //perskaiciuojami duomenys, susije su sekanciais Nuotakos pasirinkimu
    double[] Calc_bride_next(double d_bride,double d_groom, double last, double sns) {
	    double[] w=new double[100];
        double []p_w = new double[100];
        int i, j;
        double tt;
        double sum;

        //suformuojamas p(w)
        for(i=0;i<100;i++) {
            p_w[i] = probability(Sigma_w,(double)(2.0*M_w/100.0*(double)i-M_w),sns,2.0*M_w);
        }
        form_data(p_w);

        for(i=0;i<100;i++) {
            rel[local_grooms-1][i] = Nth_sum(i);
        }

        w[local_grooms] = last;

        //vyksta pasirinkimu formavimas
        for(j=local_grooms-2;j>=0;j--) {
            tt = Nth_1less_sum(j+1);
            for(i=0;i<100;i++) {
                rel[j][i] = Math.max(tt,rel[local_grooms-1][i]);
            }
            w[j] = Calc_max(j);     //kritiniai pasirinkimu taskai
        }
	return w;
	}

  //perskaiciuojami duomenys, susije su daugkartines Nuotakos pasirinkimais
    void reCalc_bride(double d_bride, double d_groom, int Uzd) {
	  int i;
	  int l_grooms;
	
	  double []old_w=new double[100];
	  double []next_w=new double[100];
	  all_w = new double[100][100];
	

	
	  if (Uzd>0){
	    Sigma_w = d_groom;
        Sigma_s = d_bride;	    
        M_w = M_s = (d_groom+d_bride)*3;	    
	  }
	  else {
	    Sigma_w = d_groom;
        Sigma_s = d_bride;
        M_w = M_s = (d_groom+d_bride)*3;	    
	 };

	w=Calc_bride(d_bride,d_groom,miu);

	for(i=0;i<local_grooms;i++)
	{
		old_w[i]=w[i];
		all_w[i][0]=w[i];	
	}

	  if (Uzd>0){
 	     reCalc_grooms_be();
	  }
	  else {    
	     reCalc_grooms();
	  };
	 
	if (multiple==1)
	{	
		num=0;
		int m=-1,p=-1;
		boolean cont=true;
		while (cont)
		{
			m=matchmake(m+1);

			cont=(m!=-1)&&(m<local_grooms)&&(m!=p);

			if ((cont)&&((p==-1)||(impr[m]>=(impr[p]+divorce))))
			{
				p=m;
				num=num+1;

				marr_impr[num-1]=impr[m];
				marr_good[num-1]=jaun[m];
				marr_groom[num-1]=m;

				M_w/=2;			// sumazinam pasiskirstyma
				M_s/=2;			// nuotaka "igijo patirties"

				l_grooms=local_grooms;
				local_grooms-=m;		// perskaiciuojam likusiems jaunikiams
				next_w=Calc_bride_next(d_bride,d_groom,impr[m]+divorce,miu);
				local_grooms=l_grooms;

				for (i=0;i<local_grooms-m-1;i++)
					w[i+m+1]=next_w[i]+impr[m]+divorce;

				for (i=0;i<local_grooms;i++)
					all_w[i][num]=w[i];	
			}
		}

	  best_groom = best();
	  good_of_best = getGroomState(best_groom);
	  impr_of_best = getImprState(best_groom);
	

	}
	else
	{
		num=0;
		int m=matchmake(0);

		marr_impr[0]=impr[m];
		marr_good[0]=jaun[m];
		marr_groom[0]=m;

 		marr_impr[1]=impr[m];
		marr_good[1]=jaun[m];
		marr_groom[1]=m;

		for (i=0;i<local_grooms;i++)
		{
			all_w[i][0]=w[i];	
			all_w[i][1]=w[i];	
		}

      best_groom = best();
	  good_of_best = getGroomState(best_groom);
	  impr_of_best = getImprState(best_groom);      
	  num = 1;

       
	}
	  //return m_i;	
    }

    //pagal pateikta jaunojo indeksa, grazinama jo gerumu reiksme
    double getGroomState(int n) {
        return jaun[n];
    }

    //pagal pateikta jaunojo indeksa, grazinama Nuotakos ispudzio reiksme
    double getImprState(int n) {
        return impr[n];
    }

    //surandamas kritinis taskas
    double Calc_max(int j) {
        int i, max;

        max = local_grooms-1;
        for(i=local_grooms-1;i>=0;i--) {
            if(rel[j][max] > rel[j][i]) max = i;
        }
        return rel[j][max];
    }

    //surandamas geriausias jaunikis
    int best() {
        int i, j=0;

        for(i=0;i<local_grooms;i++) {
            if(jaun[i]>jaun[j]) j = i;
        }
        return j;
    }

    //atliekamas pirslybu procesas
    int matchmake(int nr) {
        int i;

        for(i=nr;i<local_grooms;i++) {
            if(w[i]<=impr[i]) return i;
        }
        return -1;
    }

    //padaroma jaunikiu gerumu kopija
    void copy_groom_array(double temp[]) {
        int i;

        for(i=0;i<local_grooms;i++) {
            temp[i] = jaun[i];
        }
    }

    //padaroma jaunosios ispudziu kopija
    void copy_bride_impr_array(double temp[]) {
        int i;

        for(i=0;i<local_grooms;i++) {
            temp[i] = impr[i];
        }
    }

    //padaroma Nuotakos pasirinkimu kopija
    void copy_bride_array(double []temp) {
        int i;

        for(i=0;i<local_grooms;i++) {
            temp[i] = w[i];
        }
    }

   //padaroma Nuotakos pasirinkimu kopija
    int copy_all_bride_arrays(double [][]temp) {
        int i,k;

	for(k=0;k<=num;k++)
        for(i=0;i<local_grooms;i++) {
            temp[i][k] = all_w[i][k];
        }
	return num+1;
    }

    //perskaiciuojami duomenys susije su jaunikiais
    void reCalc_grooms() {
        int i;
        Random rr = new Random();
        double sns = 0.0;
        for(i=0;i<local_grooms;i++) {
            sns = miu * i;
            jaun[i] = nextGauss(Sigma_w,sns,2.0*M_w,rr)-waiting*i/local_grooms;		// laukimo kastai
            impr[i] = nextGauss(Sigma_s,jaun[i],2.0*M_s,rr);
        }
    }

    //perskaiciuojami duomenys susije su jaunikiais kai ekspertiniai uzd
    //MZ
    void reCalc_grooms_be() {
        int i;
        Random rr = new Random();
        
        for(i=0;i<local_grooms;i++) {
            jaun[i] = jaun[i]-waiting*i/local_grooms;		// laukimo kastai
            impr[i] = nextGauss(Sigma_s,jaun[i],2.0*M_s,rr);
        }
    }

    //added by M.Z. suformuojame data masyva
    double suformuoti_data(int uzd, int grooms, int p1, int p2, int p3, int p4, int p5, int p6,
                            int sel1, int sel2, int sel3, int sel4, int sel5, int sel6  ){
   
    int s1,s2,s3,s4,s5,s6;
    double max;
    double rez;
    Random rr = new Random(); 
    max = 0.0;
    max += sel1*0.30;
    max += sel2*0.30;
    max += sel3*0.40;
    max += sel4*0.30;
    max += sel5*0.40;
    max += sel6*0.30;     // nuo 2 iki 8 kazkur
	for(int i=0;i<local_grooms;i++) {
	    
    		s1 = (int)(1 + (p1 * rr.nextDouble()));
    		s2 = (int)(1 + (p2 * rr.nextDouble()));
    		s3 = (int)(1 + (p3 * rr.nextDouble()));
    		s4 = (int)(1 + (p4 * rr.nextDouble()));
    		s5 = (int)(1 + (p5 * rr.nextDouble()));    		
    		s6 = (int)(1 + (p6 * rr.nextDouble()));    		
            data[i]=100000*s1;
    		data[i]+=10000*s2;
    		data[i]+=1000*s3;    		
    		data[i]+=100*s4;    		
    		data[i]+=10*s5;    		
    		data[i]+=s6;    		
    		randata[i] = 0.0;
    		if (s1==sel1)  { randata[i] += ((s1 * 100)/p1)*0.30; }
    		else { randata[i] += ((s1 * 100)/p1)*0.10; };
    		if (s2==sel2) { randata[i] += ((s2 * 100)/p2)*0.30; }
    		else { randata[i] += ((s2 * 100)/p2)*0.10; };    		
    		if (s3==sel3) { randata[i] += ((s3 * 100)/p3)*0.40; }
    		else { randata[i] += ((s3 * 100)/p3)*0.15; };
    		if (s4==sel4) { randata[i] += ((s4 * 100)/p4)*0.30; }
    		else { randata[i] += ((s4 * 100)/p4)*0.10; };
    		if (s5==sel5) { randata[i] += ((s5 * 100)/p5)*0.40; }
    		else { randata[i] += ((s5 * 100)/p5)*0.15; };
    		if (s6==sel6) { randata[i] += ((s6 * 100)/p6)*0.30; }
    		else { randata[i] += ((s6 * 100)/p6)*0.10; };    		
    		randata[i] = ((randata[i])*2/100) - 1.0; 
    		jaun[i] = randata[i];
    		
    	  }     
     	  rez = (max/10);
    	  return rez;
         //}
    }

    //inicializavimas
    void init(int Pas_Uzd, int grooms, double d_br, double d_gr, double waiting, double divorce, double senpro,int which) {
        int i;
	    multiple=which;
        rel = new double[grooms][101];
        jaun = new double[grooms];
        w = new double[grooms];
        p_w_s = new double[101][101];
        p_sw = new double[101][101];
        ps_s = new double[101];
        impr = new double[grooms];
        data = new int[grooms];
        randata = new double[grooms];
        miu = senpro;
	    this.waiting=waiting;
	    this.divorce=divorce;
        local_grooms = grooms;        
    }
}