package test2;

/*
 * Created by IntelliJ IDEA.
 * User: MoRs
 * Date: Jan 6, 2002
 * Time: 7:02:20 PM
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */

import javax.swing.text.*;

public class NumberDocument extends PlainDocument
{
        public static final int INT_FORMAT = 0;
        public static final int DOUBLE_FORMAT = 1;

        protected int format;

        public NumberDocument(int format)
        {
                super();

                this.format = format;
        }

        public void insertString(int offset, String s, AttributeSet attributeset) throws BadLocationException
        {
                StringBuffer tmp = new StringBuffer(getText(0, getLength()));
                tmp.insert(offset, s);

                try
                {
                        this.parse(tmp.toString());
                        super.insertString(offset, s, attributeset);
                }
                catch (NumberFormatException _ex)
                {
                        //this exception is raised when trying to parse new string to Integer
                        //if parsing fails then string is not inserted
                }
        }

        public void remove(int offset, int length) throws BadLocationException
        {
                StringBuffer tmp = new StringBuffer(getText(0, getLength()));
                tmp.delete(offset, offset + length);

                try
                {
                        this.parse(tmp.toString());
                        super.remove(offset, length);
                }
                catch (NumberFormatException _ex)
                {
                        //this exception is raised when trying to parse new string to Integer
                        //if parsing fails then string is not deleted
                }
        }

        protected void parse(String s) throws NumberFormatException
        {
                if (this.format == INT_FORMAT)
                {
                        Integer.valueOf(s);
                }
                else if (this.format == DOUBLE_FORMAT)
                {
                        Double.valueOf(s);
                }

        }
}