package test2;


import java.awt.*;

public class FramedPanel extends Panel
{

	Panel innerPanel;
	String caption;

	public FramedPanel(String name)
	{
		super();
		setBackground(Color.lightGray);
		caption = name;

		setFont(new Font("ArialNarrow", Font.PLAIN, 12));
		GridBagLayout gridL = new GridBagLayout();
		GridBagConstraints gridC = new GridBagConstraints();
		super.setLayout(gridL);
		gridC.fill = GridBagConstraints.BOTH;

		gridC.insets = new Insets(13, 13, 6, 13);
		gridC.weightx = 1.0;
		gridC.weighty = 1.0;
		innerPanel = new Panel();
		innerPanel.setBackground(Color.lightGray);
		gridL.setConstraints(innerPanel, gridC);
		super.add(innerPanel);
	}

	public void paint(Graphics g)
	{
		Font titlesFont = new Font("ArialNarrow", Font.PLAIN, 12);
		g.setFont(titlesFont);
		g.setColor(Color.black);
		g.drawString(caption, 10, 9);

		g.setColor(Color.white);
		g.drawLine(5, 5, 8, 5);
		g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(caption), 5, getSize().width - 6, 5);
		g.drawLine(5, 5, 5, getSize().height - 6);
		g.drawLine(getSize().width - 5, 5, getSize().width - 5, getSize().height - 6);
		g.drawLine(getSize().width - 5, getSize().height - 5, 5, getSize().height - 5);

		g.setColor(Color.gray);
		g.drawLine(4, 4, 8, 4);
		g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(caption), 4, getSize().width - 5, 4);
		g.drawLine(4, 4, 4, getSize().height - 5);
		g.drawLine(getSize().width - 6, 6, getSize().width - 6, getSize().height - 7);
		g.drawLine(getSize().width - 7, getSize().height - 6, 6, getSize().height - 6);
	}

	public Component add(Component c)
	{
		return innerPanel.add(c);
	}

	public void add(Component c, Object constraints)
	{
		GridBagLayout gbl = (GridBagLayout)innerPanel.getLayout();
		gbl.setConstraints(c, (GridBagConstraints)constraints);
		innerPanel.add(c);
	}

	public void setLayout(LayoutManager mgr)
	{
		if (innerPanel != null)
		{
			innerPanel.setLayout(mgr);
		}
	}

	public LayoutManager getLayout()
	{
		if (innerPanel != null) return innerPanel.getLayout();
		return null;
	}

	public void setSize(Dimension d)
	{
//		super.setSize(d);
		innerPanel.setSize(d.width - 20, d.height - 20);
	}

	public void setSize(int width, int height)
	{
		setSize(new Dimension(width, height));
	}

	public void setBackground(Color c)
	{
		super.setBackground(c);
		//innerPanel.super.setBackground(c);
	}

	public void setTitle(String name)
	{
		caption = name;
		super.repaint();
	}

}