/*
 * Decompiled with CFR 0.152.
 */
package test2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;

public class FramedPanel
extends Panel {
    Panel innerPanel;
    String caption;

    public FramedPanel(String name) {
        this.setBackground(Color.lightGray);
        this.caption = name;
        this.setFont(new Font("ArialNarrow", 0, 12));
        GridBagLayout gridL = new GridBagLayout();
        GridBagConstraints gridC = new GridBagConstraints();
        super.setLayout(gridL);
        gridC.fill = 1;
        gridC.insets = new Insets(13, 13, 6, 13);
        gridC.weightx = 1.0;
        gridC.weighty = 1.0;
        this.innerPanel = new Panel();
        this.innerPanel.setBackground(Color.lightGray);
        gridL.setConstraints(this.innerPanel, gridC);
        super.add(this.innerPanel);
    }

    public void paint(Graphics g) {
        Font titlesFont = new Font("ArialNarrow", 0, 12);
        g.setFont(titlesFont);
        g.setColor(Color.black);
        g.drawString(this.caption, 10, 9);
        g.setColor(Color.white);
        g.drawLine(5, 5, 8, 5);
        g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(this.caption), 5, this.getSize().width - 6, 5);
        g.drawLine(5, 5, 5, this.getSize().height - 6);
        g.drawLine(this.getSize().width - 5, 5, this.getSize().width - 5, this.getSize().height - 6);
        g.drawLine(this.getSize().width - 5, this.getSize().height - 5, 5, this.getSize().height - 5);
        g.setColor(Color.gray);
        g.drawLine(4, 4, 8, 4);
        g.drawLine(10 + g.getFontMetrics(titlesFont).stringWidth(this.caption), 4, this.getSize().width - 5, 4);
        g.drawLine(4, 4, 4, this.getSize().height - 5);
        g.drawLine(this.getSize().width - 6, 6, this.getSize().width - 6, this.getSize().height - 7);
        g.drawLine(this.getSize().width - 7, this.getSize().height - 6, 6, this.getSize().height - 6);
    }

    public Component add(Component c) {
        return this.innerPanel.add(c);
    }

    public void add(Component c, Object constraints) {
        GridBagLayout gbl = (GridBagLayout)this.innerPanel.getLayout();
        gbl.setConstraints(c, (GridBagConstraints)constraints);
        this.innerPanel.add(c);
    }

    public void setLayout(LayoutManager mgr) {
        if (this.innerPanel != null) {
            this.innerPanel.setLayout(mgr);
        }
    }

    public LayoutManager getLayout() {
        if (this.innerPanel != null) {
            return this.innerPanel.getLayout();
        }
        return null;
    }

    public void setSize(Dimension d) {
        this.innerPanel.setSize(d.width - 20, d.height - 20);
    }

    public void setSize(int width, int height) {
        this.setSize(new Dimension(width, height));
    }

    public void setBackground(Color c) {
        super.setBackground(c);
    }

    public void setTitle(String name) {
        this.caption = name;
        super.repaint();
    }
}

