/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.swing.tree;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class StaticTreeNode
implements TreeNode {
    private TreeNode parent;
    private Vector nodes;

    protected abstract Vector loadSubtree();

    public Vector nodes() {
        return this.nodes;
    }

    private void validateSubtree() {
        if (this.getAllowsChildren() && this.nodes == null) {
            this.nodes = this.loadSubtree();
        }
    }

    public TreeNode getChildAt(int n) {
        this.validateSubtree();
        return (TreeNode)this.nodes.elementAt(n);
    }

    public int getChildCount() {
        this.validateSubtree();
        return this.nodes.size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.nodes.indexOf(treeNode);
    }

    public Enumeration children() {
        this.validateSubtree();
        return this.nodes.elements();
    }

    public boolean isLeaf() {
        this.validateSubtree();
        return this.nodes.size() == 0;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public StaticTreeNode(TreeNode treeNode) {
        this.parent = treeNode;
    }
}

