/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JTextLabel
extends JComponent {
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    protected String[] text;
    protected int alignment;

    public void setHorizontalAlignment(int n) {
        this.alignment = n;
    }

    public void setText(String string) {
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        this.text = new String[n];
        n2 = 0;
        while (n2 < n) {
            this.text[n2] = new String();
            ++n2;
        }
        n = 0;
        n2 = 0;
        while (n2 < string.length()) {
            switch (string.charAt(n2)) {
                case '\r': {
                    break;
                }
                case '\n': {
                    ++n;
                    break;
                }
                default: {
                    int n3 = n;
                    this.text[n3] = this.text[n3] + string.charAt(n2);
                }
            }
            ++n2;
        }
        this.invalidate();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
        int n = 0;
        int n2 = 0;
        while (n2 < this.text.length) {
            n = Math.max(n, fontMetrics.stringWidth(this.text[n2]));
            ++n2;
        }
        return new Dimension(n + fontMetrics.getAscent(), this.text.length * fontMetrics.getHeight() + fontMetrics.getLeading());
    }

    public void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent() / 2;
        int n2 = 0;
        while (n2 < this.text.length) {
            int n3 = n2 * fontMetrics.getHeight() + fontMetrics.getAscent();
            if (this.text[n2] != null) {
                switch (this.alignment) {
                    case 3: {
                        graphics.drawString(this.text[n2], rectangle.width - fontMetrics.stringWidth(this.text[n2]) - n, n3);
                        break;
                    }
                    case 2: {
                        graphics.drawString(this.text[n2], n, n3);
                        break;
                    }
                    case 1: {
                        graphics.drawString(this.text[n2], (rectangle.width - fontMetrics.stringWidth(this.text[n2])) / 2, n3);
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    public JTextLabel() {
        this(2);
    }

    public JTextLabel(int n) {
        this.text = new String[0];
        this.alignment = n;
    }

    public JTextLabel(String[] stringArray, int n) {
        this.alignment = n;
        this.text = stringArray;
    }

    public JTextLabel(String[] stringArray) {
        this(stringArray, 2);
    }

    public JTextLabel(String string, int n) {
        this.alignment = n;
        this.setText(string);
    }

    public JTextLabel(String string) {
        this(string, 2);
    }
}

