/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import lt.monarch.chart.Chart;
import lt.monarch.chart.ChartContainer;

public class JChartPanel
extends JPanel
implements ChartContainer {
    protected Chart chart;

    private void updateChartSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        this.chart.setContainer(this, new Rectangle(insets.left, insets.top, dimension.width - insets.right - insets.left, dimension.height - insets.bottom - insets.top));
    }

    public Component getComponent() {
        return this;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.chart.tipAt(mouseEvent.getPoint());
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.chart.paint(graphics);
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    /* synthetic */ void access$0() {
        this.updateChartSize();
    }

    public JChartPanel(Chart chart) {
        this.setBackground(Color.white);
        this.chart = chart;
        this.updateChartSize();
        JChartPanel jChartPanel = this;
        if (jChartPanel == null) {
            throw null;
        }
        this.addComponentListener(new ComponentAdapter(jChartPanel){
            private final /* synthetic */ JChartPanel this$0;

            public void componentResized(ComponentEvent componentEvent) {
                this.this$0.access$0();
            }
            {
                this.this$0 = jChartPanel;
                this.constructor$0(jChartPanel);
            }

            public void constructor$0(JChartPanel jChartPanel) {
            }
        });
    }
}

