/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.jasm;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ConstantPool {
    Vector pool = new Vector();
    String thisClassName;

    public void setThisClassName(String string) {
        this.thisClassName = string;
    }

    public int define(double d) {
        return this.findOrAdd(new Double(d), true);
    }

    public int define(float f) {
        return this.findOrAdd(new Float(f), true);
    }

    public int define(int n) {
        return this.findOrAdd(new Integer(n), false);
    }

    public int define(long l) {
        return this.findOrAdd(new Long(l), true);
    }

    public int define(String string) {
        return this.findOrAdd(new int[]{8, this.defineUTF8(string)}, false);
    }

    public int defineClass(String string) {
        if (string == null) {
            string = this.thisClassName;
        }
        return this.findOrAdd(new int[]{7, this.defineUTF8(string.replace('.', '/'))}, false);
    }

    public int defineNameAndType(String string, String string2) {
        return this.findOrAdd(new int[]{12, this.defineUTF8(string), this.defineUTF8(string2)}, false);
    }

    public int defineMethod(String string, String string2, String string3) {
        return this.findOrAdd(new int[]{10, this.defineClass(string), this.defineNameAndType(string2, string3)}, false);
    }

    public int defineField(String string, String string2, String string3) {
        return this.findOrAdd(new int[]{9, this.defineClass(string), this.defineNameAndType(string2, string3)}, false);
    }

    protected int defineUTF8(String string) {
        return this.findOrAdd(string, false);
    }

    private boolean constantsEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            int[] nArray2 = (int[])object2;
            if (nArray.length != nArray2.length) {
                return false;
            }
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != nArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return object.equals(object2);
    }

    private int findOrAdd(Object object, boolean bl) {
        int n = 0;
        while (n < this.pool.size()) {
            if (this.constantsEqual(object, this.pool.elementAt(n))) {
                return n + 1;
            }
            ++n;
        }
        this.pool.addElement(object);
        if (bl) {
            this.pool.addElement(null);
            return this.pool.size() - 1;
        }
        return this.pool.size();
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.pool.size() + 1);
        int n = 0;
        while (n < this.pool.size()) {
            this.writePoolEntry(dataOutputStream, this.pool.elementAt(n));
            ++n;
        }
    }

    void writePoolEntry(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object instanceof Double) {
            dataOutputStream.write(6);
            dataOutputStream.writeDouble((Double)object);
        }
        if (object instanceof Float) {
            dataOutputStream.write(4);
            dataOutputStream.writeFloat(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            dataOutputStream.write(3);
            dataOutputStream.writeInt((Integer)object);
        }
        if (object instanceof Long) {
            dataOutputStream.write(5);
            dataOutputStream.writeLong((Long)object);
        } else if (object instanceof String) {
            dataOutputStream.write(1);
            dataOutputStream.writeUTF((String)object);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            dataOutputStream.write(nArray[0]);
            int n = 1;
            while (n < nArray.length) {
                dataOutputStream.writeShort(nArray[n]);
                ++n;
            }
        }
    }
}

