/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import lt.monarch.function.Identifier;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.StdFunction;
import lt.monarch.function.Variable;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.DivNode;
import lt.monarch.function.node.IdentifierNode;
import lt.monarch.function.node.MulNode;
import lt.monarch.function.node.OperatorNode;
import lt.monarch.function.node.PlusNode;
import lt.monarch.function.node.SumNode;
import lt.monarch.function.node.TimesNode;

public class PowerNode
extends OperatorNode {
    public Node cloneNode() {
        return new PowerNode(this.l.cloneNode(), this.r.cloneNode());
    }

    public Node simplifyOperation() {
        if (this.r instanceof ConstantNode && this.r.evaluate() == 1.0) {
            return this.l;
        }
        if (this.r instanceof ConstantNode && this.r.evaluate() == 0.0) {
            return new ConstantNode(1.0);
        }
        if (this.l instanceof ConstantNode && this.l.evaluate() == 1.0) {
            return this.l;
        }
        if (this.l instanceof PowerNode) {
            PowerNode powerNode = (PowerNode)this.l;
            return new PowerNode(powerNode.termNode(), new MulNode(powerNode.powerNode(), this.r).simplifyOperation());
        }
        return super.simplifyOperation();
    }

    public String toString() {
        return (this.l instanceof SumNode || this.l instanceof TimesNode ? "(" + this.l + ")" : this.l.toString()) + "^" + (this.r instanceof SumNode || this.r instanceof TimesNode ? "(" + this.r + ")" : this.r.toString());
    }

    public double evaluate() {
        return Math.pow(this.l.evaluate(), this.r.evaluate());
    }

    public Node powerNode() {
        return this.r;
    }

    public Node termNode() {
        return this.l;
    }

    public Node derivative(Variable variable) {
        return new MulNode(this, new PlusNode(new DivNode(new MulNode(this.l.derivative(variable), this.r), this.l), new MulNode(new IdentifierNode((Identifier)new StdFunction(4), this.l), this.r.derivative(variable))));
    }

    public void compile(NodeCompiler nodeCompiler) {
        int n;
        double d;
        if (this.r instanceof ConstantNode && (d = this.r.evaluate()) == (double)(n = (int)d) && n <= 5 && n > 0) {
            this.l.compile(nodeCompiler);
            nodeCompiler.reserveStack(--n * 2);
            int n2 = 0;
            while (n2 < n) {
                nodeCompiler.append(92);
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                nodeCompiler.append(107);
                ++n2;
            }
            nodeCompiler.freeStack(n * 2);
            return;
        }
        this.l.compile(nodeCompiler);
        this.r.compile(nodeCompiler);
        nodeCompiler.appendStaticCall("java.lang.Math", "pow", "(DD)D");
        nodeCompiler.freeStack(2);
    }

    public PowerNode(Node node, Node node2) {
        super(node, node2);
    }
}

