/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import java.util.Vector;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.Variable;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.NegativeNode;
import lt.monarch.function.node.SumNode;

public class MinusNode
extends SumNode {
    public Node cloneNode() {
        return new MinusNode(this.l.cloneNode(), this.r.cloneNode());
    }

    public String toString() {
        return this.l + "-" + this.r;
    }

    public double evaluate() {
        return this.l.evaluate() - this.r.evaluate();
    }

    public Node simplifyOperation() {
        if (this.r instanceof ConstantNode && this.r.evaluate() == 0.0) {
            return this.l;
        }
        if (this.l instanceof ConstantNode && this.l.evaluate() == 0.0) {
            return new NegativeNode(this.r);
        }
        return super.simplifyOperation();
    }

    protected void enumerateOperands(Vector vector) {
        Vector<Node> vector2 = new Vector<Node>();
        if (!(this.l instanceof SumNode)) {
            this.l = this.l.simplify();
        }
        if (!(this.r instanceof SumNode)) {
            this.r = this.r.simplify();
        }
        if (this.l instanceof SumNode) {
            ((SumNode)this.l).enumerateOperands(vector);
        } else {
            vector.addElement(this.l);
        }
        if (this.r instanceof SumNode) {
            ((SumNode)this.r).enumerateOperands(vector2);
        } else {
            vector2.addElement(this.r);
        }
        int n = 0;
        while (n < vector2.size()) {
            Node node = (Node)vector2.elementAt(n);
            vector.addElement(new NegativeNode(node).simplifyOperation());
            ++n;
        }
    }

    public Node derivative(Variable variable) {
        return new MinusNode(this.l.derivative(variable), this.r.derivative(variable));
    }

    public void compile(NodeCompiler nodeCompiler) {
        this.l.compile(nodeCompiler);
        this.r.compile(nodeCompiler);
        nodeCompiler.append(103);
        nodeCompiler.freeStack(2);
    }

    public MinusNode(Node node, Node node2) {
        super(node, node2);
    }
}

