/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import lt.monarch.function.Identifier;
import lt.monarch.function.MacroIdentifier;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.Variable;
import lt.monarch.function.node.AbstractNode;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.MulNode;
import lt.monarch.function.node.PlusNode;

public class IdentifierNode
extends AbstractNode {
    protected static Node[] noParams = new Node[0];
    protected Identifier identifier;
    protected Node[] params;
    protected double[] values;

    public void visited(Node.Visitor visitor) {
        super.visited(visitor);
        int n = 0;
        while (n < this.params.length) {
            this.params[n].visited(visitor);
            ++n;
        }
    }

    public Node cloneNode() {
        Node[] nodeArray = new Node[this.params.length];
        int n = 0;
        while (n < nodeArray.length) {
            nodeArray[n] = this.params[n].cloneNode();
            ++n;
        }
        return new IdentifierNode(this.identifier, nodeArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.identifier.name());
        if (this.params.length != 0) {
            stringBuffer.append("(");
            int n = 0;
            while (n < this.params.length) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.params[n].toString());
                ++n;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public Node simplify() {
        if (this.identifier instanceof MacroIdentifier) {
            return ((MacroIdentifier)this.identifier).expand(this.params);
        }
        boolean bl = true;
        int n = 0;
        while (n < this.params.length) {
            this.params[n] = this.params[n].simplify();
            bl &= this.params[n] instanceof ConstantNode;
            ++n;
        }
        if (this.params.length != 0 && bl || this.identifier.isConstant()) {
            return new ConstantNode(this.evaluate());
        }
        return this;
    }

    public double evaluate() {
        int n = 0;
        while (n < this.params.length) {
            this.values[n] = this.params[n].evaluate();
            ++n;
        }
        return this.identifier.evaluate(this.values);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        IdentifierNode identifierNode = (IdentifierNode)object;
        return this.identifier.equals(identifierNode.identifier) && this.paramsEquals(identifierNode.params);
    }

    private boolean paramsEquals(Node[] nodeArray) {
        if (nodeArray.length != this.params.length) {
            return false;
        }
        int n = 0;
        while (n < this.params.length) {
            if (!this.params[n].equals(nodeArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Node derivative(Variable variable) {
        if (variable == this.identifier) {
            return new ConstantNode(1.0);
        }
        Node node = new ConstantNode(0.0);
        int n = 0;
        while (n < this.params.length) {
            IdentifierNode identifierNode = new IdentifierNode(this.identifier.derivative(n), this.params);
            Node node2 = this.params[n].derivative(variable);
            Node node3 = new MulNode(identifierNode, node2).simplifyOperation();
            node = new PlusNode(node, node3).simplifyOperation();
            ++n;
        }
        return node;
    }

    public void compile(NodeCompiler nodeCompiler) {
        this.identifier.compileRef(nodeCompiler, this.params);
    }

    public IdentifierNode(Identifier identifier, Node[] nodeArray) {
        this.identifier = identifier;
        this.params = nodeArray;
        if (this.params.length != 0) {
            this.values = new double[this.params.length];
        }
    }

    public IdentifierNode(Identifier identifier, Node node) {
        this(identifier, new Node[]{node});
    }

    public IdentifierNode(Identifier identifier) {
        this(identifier, noParams);
    }
}

