/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function;

import lt.monarch.function.Identifier;
import lt.monarch.function.MacroFunction;
import lt.monarch.function.MacroParameter;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.DivNode;
import lt.monarch.function.node.IdentifierNode;
import lt.monarch.function.node.NegativeNode;

public class StdFunction
implements Identifier {
    public static final int SIN = 1;
    public static final int COS = 2;
    public static final int ABS = 3;
    public static final int LOG = 4;
    private int function;

    public boolean isConstant() {
        return false;
    }

    public String name() {
        switch (this.function) {
            case 1: {
                return "sin";
            }
            case 2: {
                return "cos";
            }
            case 3: {
                return "abs";
            }
            case 4: {
                return "ln";
            }
        }
        return null;
    }

    protected String javaMathFunctionName() {
        switch (this.function) {
            case 1: {
                return "sin";
            }
            case 2: {
                return "cos";
            }
            case 3: {
                return "abs";
            }
            case 4: {
                return "log";
            }
        }
        return null;
    }

    public int parameterCount() {
        return 1;
    }

    public double evaluate(double[] dArray) {
        switch (this.function) {
            case 1: {
                return Math.sin(dArray[0]);
            }
            case 2: {
                return Math.cos(dArray[0]);
            }
            case 3: {
                return Math.abs(dArray[0]);
            }
            case 4: {
                return Math.log(dArray[0]);
            }
        }
        return 0.0;
    }

    public Identifier derivative(int n) {
        MacroParameter macroParameter = new MacroParameter("x");
        MacroParameter[] macroParameterArray = new MacroParameter[]{macroParameter};
        switch (this.function) {
            case 1: {
                return new MacroFunction("sin'", macroParameterArray, new IdentifierNode((Identifier)new StdFunction(2), new IdentifierNode(macroParameter)));
            }
            case 2: {
                return new MacroFunction("cos'", macroParameterArray, new NegativeNode(new IdentifierNode((Identifier)new StdFunction(1), new IdentifierNode(macroParameter))));
            }
            case 3: {
                return new StdFunction(3);
            }
            case 4: {
                return new MacroFunction("ln'", macroParameterArray, new DivNode(new ConstantNode(1.0), new IdentifierNode(macroParameter)));
            }
        }
        return null;
    }

    public void compileRef(NodeCompiler nodeCompiler, Node[] nodeArray) {
        nodeArray[0].compile(nodeCompiler);
        nodeCompiler.appendStaticCall("java.lang.Math", this.javaMathFunctionName(), "(D)D");
    }

    public StdFunction(int n) {
        this.function = n;
    }
}

