/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function;

import lt.monarch.function.AbstractIdentifier;
import lt.monarch.function.FunctionError;
import lt.monarch.function.Identifier;
import lt.monarch.function.MacroIdentifier;
import lt.monarch.function.MacroParameter;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.node.ConstantNode;

public class MacroFunction
extends AbstractIdentifier
implements MacroIdentifier {
    protected Node body;
    protected MacroParameter[] params;

    public int parameterCount() {
        return this.params.length;
    }

    public MacroParameter[] parameters() {
        return this.params;
    }

    public synchronized double evaluate(double[] dArray) {
        int n = 0;
        while (n < this.params.length) {
            this.params[n].setNode(new ConstantNode(dArray[n]));
            ++n;
        }
        return this.body.evaluate();
    }

    public synchronized Node expand(Node[] nodeArray) {
        int n = 0;
        while (n < this.params.length) {
            this.params[n].setNode(nodeArray[n]);
            ++n;
        }
        return this.body.cloneNode().simplify();
    }

    public Identifier derivative(int n) {
        throw new FunctionError("Derivative not supported");
    }

    public synchronized void compileRef(NodeCompiler nodeCompiler, Node[] nodeArray) {
        int n = 0;
        while (n < this.params.length) {
            this.params[n].setNode(nodeArray[n]);
            ++n;
        }
        this.body.compile(nodeCompiler);
    }

    public MacroFunction(String string, MacroParameter[] macroParameterArray, Node node) {
        super(string);
        this.body = node;
        this.params = macroParameterArray;
    }
}

