/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function;

import lt.monarch.function.AbstractIdentifier;
import lt.monarch.function.Identifier;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.Variable;
import lt.monarch.function.node.ConstantNode;

public class Function
extends AbstractIdentifier {
    protected Node body;
    protected Variable[] params;

    public int parameterCount() {
        return this.params.length;
    }

    public Variable[] parameters() {
        return this.params;
    }

    public boolean isConstant() {
        return this.body instanceof ConstantNode;
    }

    public Node body() {
        return this.body;
    }

    public double evaluate(double[] dArray) {
        int n = 0;
        while (n < this.params.length) {
            this.params[n].setValue(dArray[n]);
            ++n;
        }
        return this.body.evaluate();
    }

    public Identifier derivative(int n) {
        return new Function(this.name() + "'" + (n + 1), this.params, this.body.derivative(this.params[n]));
    }

    public String javaFunctionName() {
        return this.name().replace('\'', '_');
    }

    public String javaFunctionDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.params.length) {
            stringBuffer.append('D');
            ++n;
        }
        return "(" + stringBuffer.toString() + ")D";
    }

    public void compile(NodeCompiler nodeCompiler) {
        nodeCompiler.setParameters(this.params);
        nodeCompiler.compile(this.body);
    }

    public void compileRef(NodeCompiler nodeCompiler, Node[] nodeArray) {
        if (!nodeCompiler.functionSet().hasMethod(this.javaFunctionName(), this.javaFunctionDescriptor())) {
            NodeCompiler nodeCompiler2 = new NodeCompiler(nodeCompiler.functionSet(), this.javaFunctionName());
            nodeCompiler2.setParameters(true, this.javaFunctionDescriptor(), this.params);
            nodeCompiler2.compile(this.body);
            nodeCompiler.functionSet().addMethod(nodeCompiler2);
        }
        int n = 0;
        while (n < nodeArray.length) {
            nodeArray[n].compile(nodeCompiler);
            ++n;
        }
        nodeCompiler.appendStaticCall(null, this.javaFunctionName(), this.javaFunctionDescriptor());
        nodeCompiler.freeStack(2 * (this.params.length - 1));
    }

    public Function(String string, Variable[] variableArray, Node node) {
        super(string);
        this.body = node.simplify();
        this.params = variableArray;
    }
}

