/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.debug;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import lt.monarch.debug.ErrorLogEngine;
import lt.monarch.debug.SwingLogTreeModel;

public class SwingListLogEngine
extends JDialog
implements ErrorLogEngine {
    private SwingLogTreeModel log;
    private JButton button;
    private boolean initialized = false;
    private boolean logEmpty = true;
    private boolean logClosed = false;
    private boolean disposeOnLogClose = false;

    private void setup() {
        this.setTitle("Log");
        this.setDefaultCloseOperation(0);
        SwingListLogEngine swingListLogEngine = this;
        if (swingListLogEngine == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(swingListLogEngine){
            private final /* synthetic */ SwingListLogEngine this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.access$0();
            }
            {
                this.this$0 = swingListLogEngine;
                this.constructor$0(swingListLogEngine);
            }

            public void constructor$0(SwingListLogEngine swingListLogEngine) {
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.log = new SwingLogTreeModel();
        JTree jTree = new JTree(this.log);
        jTree.setCellRenderer(new SwingLogTreeModel.CellRenderer());
        jTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(jTree);
        jScrollPane.getViewport().setBackingStoreEnabled(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.button = new JButton();
        jPanel2.add(this.button);
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", jPanel2);
        SwingListLogEngine swingListLogEngine2 = this;
        if (swingListLogEngine2 == null) {
            throw null;
        }
        this.button.addActionListener(new ActionListener(swingListLogEngine2){
            private final /* synthetic */ SwingListLogEngine this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.this$0.access$1()) {
                    this.this$0.access$2().clear();
                    this.this$0.access$3(true);
                    this.this$0.access$4();
                    return;
                }
                this.this$0.access$0();
            }
            {
                this.this$0 = swingListLogEngine;
                this.constructor$0(swingListLogEngine);
            }

            public void constructor$0(SwingListLogEngine swingListLogEngine) {
            }
        });
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.logEmpty && this.button.getText() != "Close") {
            this.button.setText("Close");
        }
        if (!this.logEmpty && this.button.getText() != "Clear") {
            this.button.setText("Clear");
        }
    }

    private void closeClicked() {
        if (this.logClosed) {
            this.dispose();
        } else {
            ((Component)this).setVisible(false);
        }
    }

    public void setDisposeOnLogClose(boolean bl) {
        this.disposeOnLogClose = bl;
    }

    public void close() {
        if (this.disposeOnLogClose) {
            SwingListLogEngine swingListLogEngine = this;
            if (swingListLogEngine == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(swingListLogEngine){
                private final /* synthetic */ SwingListLogEngine this$0;

                public void run() {
                    this.this$0.access$6(true);
                    this.this$0.dispose();
                }
                {
                    this.this$0 = swingListLogEngine;
                    this.constructor$0(swingListLogEngine);
                }

                public void constructor$0(SwingListLogEngine swingListLogEngine) {
                }
            });
        }
    }

    public void log(ErrorLogEngine.LogPacket logPacket) {
        SwingListLogEngine swingListLogEngine = this;
        if (swingListLogEngine == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(swingListLogEngine, logPacket){
            private final /* synthetic */ SwingListLogEngine this$0;
            private final /* synthetic */ ErrorLogEngine.LogPacket val$packet;

            public void run() {
                this.this$0.access$7(this.val$packet);
            }
            {
                this.val$packet = logPacket;
                this.this$0 = swingListLogEngine;
                this.constructor$0(swingListLogEngine);
            }

            public void constructor$0(SwingListLogEngine swingListLogEngine) {
            }
        });
    }

    private void safeLog(ErrorLogEngine.LogPacket logPacket) {
        this.log.add(logPacket);
        this.logEmpty = false;
        this.updateButtons();
        if (!this.initialized) {
            this.initialized = true;
            ((Component)this).setBounds(new Rectangle(this.getToolkit().getScreenSize().width / 6, this.getToolkit().getScreenSize().height / 6, this.getToolkit().getScreenSize().width / 2, this.getToolkit().getScreenSize().height / 3));
        }
        if (!this.isVisible()) {
            this.show();
        }
    }

    /* synthetic */ void access$0() {
        this.closeClicked();
    }

    /* synthetic */ boolean access$1() {
        return this.logEmpty;
    }

    /* synthetic */ SwingLogTreeModel access$2() {
        return this.log;
    }

    /* synthetic */ void access$3(boolean bl) {
        this.logEmpty = bl;
    }

    /* synthetic */ void access$4() {
        this.updateButtons();
    }

    /* synthetic */ boolean access$5() {
        return this.logClosed;
    }

    /* synthetic */ void access$6(boolean bl) {
        this.logClosed = bl;
    }

    /* synthetic */ void access$7(ErrorLogEngine.LogPacket logPacket) {
        this.safeLog(logPacket);
    }

    public SwingListLogEngine() {
        this((Frame)null);
        this.setup();
    }

    public SwingListLogEngine(Frame frame) {
        super(frame);
        this.setup();
    }
}

