/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.charts;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lt.monarch.charts.Axis;
import lt.monarch.charts.AxisMapper;

public class YAxis
extends Axis {
    boolean alignRight;

    public YAxis(AxisMapper axisMapper) {
        super(axisMapper);
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.black);
        if (this.alignRight) {
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        } else {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        }
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mapper.labelCount()) {
            n2 += fontMetrics.getHeight();
            ++n3;
        }
        int n4 = (int)Math.floor((double)n2 / (double)rectangle.height) + 1;
        int n5 = this.label != null ? n4 : 0;
        int n6 = 0;
        while (n6 < this.mapper.labelCount() - n5) {
            String string = this.mapper.label(n6);
            int n7 = this.alignRight ? rectangle.x + rectangle.width - fontMetrics.stringWidth(string) - n * 2 : rectangle.x + n * 2;
            int n8 = this.mapLabel(rectangle, n6);
            graphics.drawString(string, n7, n8 + fontMetrics.getHeight() / 3);
            if (this.alignRight) {
                graphics.drawLine(rectangle.x + rectangle.width, n8, rectangle.x + rectangle.width - n, n8);
            } else {
                graphics.drawLine(rectangle.x, n8, rectangle.x + n, n8);
            }
            n6 += n4;
        }
        if (this.label != null) {
            int n9 = this.alignRight ? rectangle.x + rectangle.width - fontMetrics.stringWidth(this.label) - n : rectangle.x + n;
            graphics.drawString(this.label, n9, rectangle.y + fontMetrics.getHeight() / 2);
        }
    }

    public int map(Rectangle rectangle, Object object) {
        return rectangle.height - this.mapper.map(rectangle.height, object) + rectangle.y;
    }

    public int mapLabel(Rectangle rectangle, int n) {
        return rectangle.height - this.mapper.mapLabel(rectangle.height, n) + rectangle.y;
    }

    public int width(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mapper.labelCount()) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.mapper.label(n3)));
            ++n3;
        }
        if (this.label != null) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.label));
        }
        return n2 + n;
    }
}

