/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.charts;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lt.monarch.charts.Axis;
import lt.monarch.charts.AxisMapper;

public class XAxis
extends Axis {
    public XAxis(AxisMapper axisMapper) {
        super(axisMapper);
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.black);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(" ");
        String string = "";
        int n2 = 0;
        while (n2 < this.mapper.labelCount()) {
            string = String.valueOf(string) + " " + this.mapper.label(n2) + " ";
            ++n2;
        }
        int n3 = (int)Math.floor((double)fontMetrics.stringWidth(string) / (double)rectangle.width) + 1;
        int n4 = this.label != null ? n3 : 0;
        int n5 = n3 / 2;
        while (n5 < this.mapper.labelCount() - n4) {
            String string2 = this.mapper.label(n5);
            int n6 = this.mapLabel(rectangle, n5);
            graphics.drawString(string2, n6 - fontMetrics.stringWidth(string2) / 2, rectangle.y + fontMetrics.getHeight() + n);
            graphics.drawLine(n6, rectangle.y, n6, rectangle.y + n);
            n5 += n3;
        }
        if (this.label != null) {
            graphics.drawString(this.label, rectangle.width + rectangle.x - fontMetrics.stringWidth(this.label), rectangle.y + fontMetrics.getHeight() + n);
        }
    }

    public int height(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        return fontMetrics.getHeight();
    }

    public int map(Rectangle rectangle, Object object) {
        return this.mapper.map(rectangle.width, object) + rectangle.x;
    }

    public int mapLabel(Rectangle rectangle, int n) {
        return this.mapper.mapLabel(rectangle.width, n) + rectangle.x;
    }
}

