/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.charts;

public class NormalizedRange {
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_NORMAL;
    private double step;
    private int steps;
    private int precisionPlaces;
    private double precision;

    public NormalizedRange() {
    }

    public NormalizedRange(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public String format(double d) {
        if (this.step < 1.0) {
            String string = String.valueOf(d = (double)Math.round(d / this.precision) * this.precision);
            if (string.indexOf(69) > 0) {
                return string;
            }
            int n = this.precisionPlaces + 1 + new Integer(Math.abs((int)d)).toString().length();
            if (d < 0.0) {
                ++n;
            }
            if (string.length() > n) {
                return string.substring(0, n);
            }
            return string;
        }
        return String.valueOf((int)d);
    }

    public String formatPrecise(double d) {
        if (this.step < 10.0) {
            double d2 = this.precision / 100.0;
            String string = String.valueOf(d = (double)Math.round(d / d2) * d2);
            if (string.indexOf(69) > 0) {
                return string;
            }
            int n = this.precisionPlaces + 3 + new Integer(Math.abs((int)d)).toString().length();
            if (d < 0.0) {
                ++n;
            }
            if (string.length() > n) {
                return string.substring(0, n);
            }
            return string;
        }
        return String.valueOf((int)d);
    }

    public int map(int n, double d) {
        return (int)((d - this.min) * (double)n / this.range());
    }

    public final double max() {
        return this.max;
    }

    public final double min() {
        return this.min;
    }

    public void normalize() {
        this.normalize(2, 10);
    }

    public void normalize(int n) {
        this.normalize(n / 2, n * 5);
    }

    protected void normalize(int n, int n2) {
        if (this.min == Double.MIN_NORMAL || this.max == Double.MAX_VALUE) {
            this.updateRange(0.0);
        }
        double[] dArray = new double[]{2.0, 5.0};
        int n3 = 0;
        this.step = 1.0;
        this.precisionPlaces = 0;
        double d = this.max - this.min;
        if (d == 0.0) {
            this.min = 0.0;
            this.max += 1.0;
            d = this.max - this.min;
        }
        while (true) {
            if (d / this.step <= (double)n) {
                this.step /= dArray[n3];
                n3 = 1 - n3;
                this.precisionPlaces += n3;
                continue;
            }
            if (d / this.step <= (double)n2) break;
            this.precisionPlaces -= n3;
            n3 = 1 - n3;
            this.step *= dArray[n3];
        }
        this.precision = 1.0;
        int n4 = 0;
        while (n4 < this.precisionPlaces) {
            this.precision /= 10.0;
            ++n4;
        }
        int n5 = 0;
        while (n5 < -this.precisionPlaces) {
            this.precision *= 10.0;
            ++n5;
        }
        double d2 = this.precision / 100.0;
        this.min = (double)Math.round(this.min / d2) * d2;
        this.max = (double)Math.round(this.max / d2) * d2;
        this.min = Math.floor(this.min / this.step) * this.step;
        this.max = Math.ceil(this.max / this.step) * this.step;
        d = this.max - this.min;
        this.steps = (int)Math.round(d / this.step);
        this.step = d / (double)this.steps;
    }

    public final double range() {
        return this.max - this.min;
    }

    public void setRange(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public final double step() {
        return this.step;
    }

    public final int steps() {
        return this.steps + 1;
    }

    public void updateRange(double d) {
        if (this.max < d) {
            this.max = d;
        }
        if (this.min > d) {
            this.min = d;
        }
    }
}

