/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import lt.monarch.chart.AbstractChartObject;
import lt.monarch.chart.NormalizedMatrix;
import lt.monarch.chart.NormalizedPoint;
import lt.monarch.chart.PlainMapper;

public class DensityMap
extends AbstractChartObject {
    protected PlainMapper mapper;
    protected NormalizedMatrix matrix;
    protected Color[] palette;

    public DensityMap(PlainMapper plainMapper, NormalizedMatrix normalizedMatrix) {
        this.mapper = plainMapper;
        this.matrix = normalizedMatrix;
        this.setPalette(DensityMap.createDefaultPalette(128));
    }

    public static Color[] createDefaultPalette(int n) {
        Color[] colorArray = new Color[n];
        float[] fArray = new float[]{0.46875f, 0.9765625f, 0.0390625f};
        float[] fArray2 = new float[]{0.1757813f, 0.9375f, 0.9960938f};
        float[] fArray3 = new float[3];
        int n2 = 0;
        while (n2 < n) {
            float f = (float)n2 / (float)(n - 1);
            fArray3[0] = (1.0f + fArray2[0] - fArray[0]) * f + fArray[0];
            fArray3[1] = (fArray[1] - fArray2[1]) * f + fArray2[1];
            fArray3[2] = (fArray2[2] - fArray[2]) * f + fArray[2];
            if (fArray3[0] > 1.0f) {
                fArray3[0] = fArray3[0] - 1.0f;
            }
            colorArray[n2] = Color.getHSBColor(fArray3[0], fArray3[1], fArray3[2]);
            ++n2;
        }
        return colorArray;
    }

    public static Color[] createGrayPalette(int n) {
        return DensityMap.createGrayPalette(n, 0.5f);
    }

    public static Color[] createGrayPalette(int n, float f) {
        Color[] colorArray = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            float f2 = (float)n2 / (float)(n - 1) / 2.0f + f;
            int n3 = (int)(255.0f * f2);
            colorArray[n2] = new Color(n3, n3, n3);
            ++n2;
        }
        return colorArray;
    }

    public void draw(Graphics graphics) {
        if (this.mapper == null) {
            this.drawImageMap(graphics);
        } else {
            this.drawPolygonMap(graphics);
        }
    }

    private void drawImageMap(Graphics graphics) {
        int n = this.matrix.resolutionX;
        int n2 = this.matrix.resolutionY;
        byte[] byArray = new byte[n * n2];
        byte[] byArray2 = new byte[this.palette.length];
        byte[] byArray3 = new byte[this.palette.length];
        byte[] byArray4 = new byte[this.palette.length];
        int n3 = 0;
        while (n3 < this.palette.length) {
            byArray2[n3] = (byte)(this.palette[n3].getRed() & 0xFF);
            byArray3[n3] = (byte)(this.palette[n3].getGreen() & 0xFF);
            byArray4[n3] = (byte)(this.palette[n3].getBlue() & 0xFF);
            ++n3;
        }
        int n4 = 0;
        while (n4 < byArray.length) {
            byArray[n4] = 50;
            ++n4;
        }
        int n5 = 0;
        int n6 = this.palette.length - 1;
        int n7 = n2 - 1;
        while (n7 >= 0) {
            int n8 = 0;
            while (n8 < n) {
                byArray[n5++] = (byte)((int)(this.matrix.z[n8][n7] * (double)n6) & 0xFF);
                ++n8;
            }
            --n7;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, this.palette.length, byArray2, byArray3, byArray4);
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, (ColorModel)indexColorModel, byArray, 0, n);
        Image image = this.chart().container().getComponent().createImage(memoryImageSource);
        MediaTracker mediaTracker = new MediaTracker(this.chart().container().getComponent());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        mediaTracker.removeImage(image, 0);
        Rectangle rectangle = this.chart().projector().getProjectionArea();
        graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        image.flush();
    }

    private void drawPolygonMap(Graphics graphics) {
        NormalizedPoint normalizedPoint = this.mapper.map(0.0, 0.0);
        Point point = new Point();
        double[] dArray = new double[2];
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        double d = this.matrix.resolutionX;
        double d2 = this.matrix.resolutionY;
        int n = this.palette.length - 1;
        int n2 = 0;
        while (n2 < this.matrix.resolutionX) {
            dArray[0] = ((double)n2 - 0.0) / d;
            dArray[1] = ((double)n2 + 1.0) / d;
            int n3 = 0;
            while (n3 < 2) {
                Point point2 = this.chart().projector().project(this.mapper.map(dArray[n3], 0.0, normalizedPoint), point);
                nArray[2 + n3] = point2.x;
                nArray2[2 + n3] = point2.y;
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.matrix.resolutionY) {
                double d3 = ((double)n4 + 1.0) / d2;
                nArray[0] = nArray[3];
                nArray2[0] = nArray2[3];
                nArray[1] = nArray[2];
                nArray2[1] = nArray2[2];
                int n5 = 0;
                while (n5 < 2) {
                    Point point3 = this.chart().projector().project(this.mapper.map(dArray[n5], d3, normalizedPoint), point);
                    nArray[2 + n5] = point3.x;
                    nArray2[2 + n5] = point3.y;
                    ++n5;
                }
                graphics.setColor(this.palette[(int)(this.matrix.z[n2][n4] * (double)n)]);
                graphics.fillPolygon(nArray, nArray2, 4);
                ++n4;
            }
            ++n2;
        }
    }

    public void setPalette(Color[] colorArray) {
        this.palette = colorArray;
    }
}

